package com.ifourthwall.dbm.estate.facade;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.dbm.estate.facade.dto.*;

import java.util.List;

/**
 * @Author: xuye
 * @Date: 2019/8/31 11:49
 * @Description:
 */
public interface BillPaymentFacade {

    /**
     * 微信新增支付信息
     * @Author: xuye
     * @Date: 2019/8/29 19:27
     * @param insertQuery
     * @return com.ifourthwall.dbm.estate.bo.BillPaymentWechatInsertQuery
     * @throws
     */
    BaseResponse<BillPaymentWechatDTO> insertWechatBillPayment(BillPaymentWechatInsertQueryDTO insertQuery);

    /**
     * 微信支付订单
     * @Author: xuye
     * @Date: 2019/8/31 11:13
     * @param queryBO
     * @return java.lang.Integer
     * @throws
     */
    BaseResponse<Integer> wechatPayBill(PayBillQueryDTO queryBO);

    /**
     * 根据微信支付账单查询对应支付信息
     * @Author: xuye
     * @Date: 2019/9/2 9:58
     * @param queryDTO
     * @return java.util.List<com.ifourthwall.dbm.estate.bo.BillPaymentBaseBO>
     * @throws
     */
    BaseResponse<List<BillPaymentBaseDTO>> listInfo(BillPaymentBaseQueryDTO queryDTO);
}
