/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.dbm.estate.facade.util;

import com.github.pagehelper.PageInfo;
import com.ifourthwall.dbm.common.util.Log4jKit;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;

public class DataUtils {
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private static SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd");
    private static SimpleDateFormat sdf4uuid = new SimpleDateFormat("yyyyMMddHHmmss");
    private static final String[] CN_UPPER_NUMBER = new String[]{"\u96f6", "\u58f9", "\u8d30", "\u53c1", "\u8086", "\u4f0d", "\u9646", "\u67d2", "\u634c", "\u7396"};
    private static final String[] CN_UPPER_MONETRAY_UNIT = new String[]{"\u5206", "\u89d2", "\u5143", "\u62fe", "\u4f70", "\u4edf", "\u4e07", "\u62fe", "\u4f70", "\u4edf", "\u4ebf", "\u62fe", "\u4f70", "\u4edf", "\u5146", "\u62fe", "\u4f70", "\u4edf"};
    private static final String CN_FULL = "\u6574";
    private static final String CN_NEGATIVE = "\u8d1f";
    private static final int MONEY_PRECISION = 2;
    private static final String CN_ZEOR_FULL = "\u96f6\u5143\u6574";

    public static String genUUID() {
        UUID uuid = UUID.randomUUID();
        return uuid.toString().replaceAll("-", "");
    }

    public static String genUUID4Time() {
        String a = sdf4uuid.format(new Date());
        String b = DataUtils.genRandom(4);
        return a + b;
    }

    public static String genRandom(int power) {
        int a = (int)(Math.random() * Math.pow(10.0, power));
        return String.format("%04d", a);
    }

    public static boolean isNotEmpty(Object ... obj) {
        boolean result = true;
        for (Object tmp : obj) {
            if (tmp instanceof String && StringUtils.isEmpty((CharSequence)((String)tmp))) {
                return false;
            }
            if (tmp != null) continue;
            return false;
        }
        return result;
    }

    public static boolean haveEmpty(Object ... obj) {
        boolean flag = DataUtils.isNotEmpty(obj);
        return !flag;
    }

    public static boolean isNotAllEmpty(Object ... obj) {
        boolean result = false;
        for (Object tmp : obj) {
            if (tmp instanceof String && !StringUtils.isEmpty((CharSequence)((String)tmp))) {
                return true;
            }
            if (tmp == null) continue;
            return true;
        }
        return result;
    }

    public static int getYear() {
        return Calendar.getInstance().get(1);
    }

    public static Date getDate(Object obj) {
        Date time = null;
        if (obj == null) {
            return time;
        }
        if (obj instanceof Long || obj instanceof Integer) {
            Date dt;
            time = dt = new Date(Long.parseLong(obj.toString()));
        } else if (obj instanceof Date) {
            time = (Date)obj;
        } else if (obj instanceof String) {
            String str = (String)obj;
            SimpleDateFormat _sdf = sdf;
            if (str.length() == 16) {
                _sdf = sdf1;
            } else if (str.length() == 10) {
                _sdf = sdf2;
            }
            try {
                time = _sdf.parse(str);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return time;
    }

    public static String getStrFromSet(Set<Integer> set) {
        String result = null;
        if (set != null && set.size() > 0) {
            StringBuilder sb = new StringBuilder("");
            for (Integer id : set) {
                sb.append(id + ",");
            }
            result = sb.substring(0, sb.length() - 1);
        }
        return result;
    }

    public static String getStrFromList(List<Integer> list) {
        String result = null;
        if (list != null && list.size() > 0) {
            StringBuilder sb = new StringBuilder("");
            for (Integer id : list) {
                sb.append(id + ",");
            }
            result = sb.substring(0, sb.length() - 1);
        }
        return result;
    }

    public static String getTimeStr(Object obj) {
        String time;
        if (obj == null) {
            return "";
        }
        if (obj instanceof Long || obj instanceof Integer) {
            Date dt = new Date(Long.parseLong(obj.toString()));
            time = sdf.format(dt);
        } else {
            time = obj instanceof Date ? sdf.format(obj) : obj.toString();
        }
        return time;
    }

    public static Map<Integer, Object> convertMap(List list) {
        HashMap<Integer, Object> map = new HashMap<Integer, Object>();
        for (Object obj : list) {
            Integer id = (Integer)obj.getClass().getDeclaredMethod("getId", null).invoke(obj, null);
            map.put(id, obj);
        }
        return map;
    }

    public static boolean isListAvali(List list) {
        return list != null && list.size() != 0;
    }

    public static <F, T> List<T> entityListToModelList(List<F> fromList, Class<T> tClass) {
        if (!DataUtils.isListAvali(fromList)) {
            return new ArrayList();
        }
        ArrayList<T> tList = new ArrayList<T>();
        for (F f : fromList) {
            T t = DataUtils.entityToModel(f, tClass);
            tList.add(t);
        }
        return tList;
    }

    public static <F, T> PageInfo<T> entityPageToModelPage(PageInfo<F> oriPage, Class<T> tClass) {
        PageInfo pageInfo = new PageInfo();
        BeanUtils.copyProperties(oriPage, (Object)pageInfo, (String[])new String[]{"list"});
        if (DataUtils.isListAvali(oriPage.getList())) {
            List<T> ts = DataUtils.entityListToModelList(oriPage.getList(), tClass);
            pageInfo.setList(ts);
        }
        return pageInfo;
    }

    public static <F, T> T entityToModel(F entity, Class<T> modelClass) {
        T model = null;
        if (entity == null || modelClass == null) {
            return null;
        }
        try {
            model = modelClass.newInstance();
        }
        catch (InstantiationException e) {
            Log4jKit.error((String)"entityToModel : \u5b9e\u4f8b\u5316\u5f02\u5e38", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            Log4jKit.error((String)"entityToModel : \u5b89\u5168\u6743\u9650\u5f02\u5e38", (Throwable)e);
        }
        BeanUtils.copyProperties(entity, model);
        return model;
    }
}

