/**
 * Project Name: dbm-ui-overlord
 * File Name: DataUtils.java
 * Package Name: com.myhitron.common.util
 * Date: 2016年9月29日 上午11:51:52
 * Copyright (c) 2016, myhitron All Rights Reserved.
 */

package com.ifourthwall.dbm.estate.facade.util;


import com.github.pagehelper.PageInfo;
import com.ifourthwall.dbm.common.util.Log4jKit;
import lombok.SneakyThrows;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;


import java.text.SimpleDateFormat;
import java.util.*;

/**
 * TODO: enter class description here
 * 2019.10.08 杨鹏导入
 * @author wuye
 * Date: 2016年9月29日 上午11:51:52
 */
public class DataUtils {

    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private static SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd");
    private static SimpleDateFormat sdf4uuid = new SimpleDateFormat("yyyyMMddHHmmss");

    private static final String[] CN_UPPER_NUMBER = { "零", "壹", "贰", "叁", "肆", "伍", "陆", "柒", "捌", "玖" };
    private static final String[] CN_UPPER_MONETRAY_UNIT = { "分", "角", "元", "拾", "佰", "仟", "万", "拾", "佰", "仟", "亿", "拾", "佰", "仟", "兆", "拾", "佰",
    "仟" };
    private static final String CN_FULL = "整";
    private static final String CN_NEGATIVE = "负";
    private static final int MONEY_PRECISION = 2;
    private static final String CN_ZEOR_FULL = "零元" + CN_FULL;

    /**
     * 得到32位随机数
     * @author wuye
     * Date: 2016年9月30日 上午11:24:59
     * @return
     */
    public static String genUUID() {
        UUID uuid = UUID.randomUUID();
        return uuid.toString().replaceAll("-", "");
    }

    /**
     * 得到由14位时间+4位随机数组成唯一代码
     * @author wuye
     * Date: 2017年10月12日 下午2:53:13
     * @return
     */
    public static String genUUID4Time() {
        String a = sdf4uuid.format(new Date());
        String b = genRandom(4);
        return a + b;
    }

    /**
     * 得到N位随机数
     * @author wuye
     * Date: 2017年8月21日 下午7:26:14
     * @param power 10的n次方，随机数位数
     * @return
     */
    public static String genRandom(int power) {
        int a = (int) (Math.random() * Math.pow(10, power));
        return String.format("%04d", a);
    }

    /**
     * 判断对象是否为空，如果是字符串必须为非空，有一个为空返回false
     * @author wuye
     * Date: 2017年10月12日 下午2:59:10
     * @param obj
     * @return
     */
    public static boolean isNotEmpty(Object... obj) {
        boolean result = true;
        for (Object tmp : obj) {
            if (tmp instanceof String && StringUtils.isEmpty((String) tmp)) {
                return false;
            } else if (tmp == null) {
                return false;
            }
        }
        return result;
    }

    /**
     * 有一个空，就返回true
     * @author xuye
     * Date: 2018年3月1日 下午5:45:24
     * @param obj
     * @return
     */
    public static boolean haveEmpty(Object... obj) {
        boolean flag = isNotEmpty(obj);
        return !flag;
    }

    /**
     * 判断对象是否为空，如果是字符串必须为非空，有一个为非空返回true
     * @author wuye
     * Date: 2017年10月25日 下午2:27:20
     * @param obj
     * @return
     */
    public static boolean isNotAllEmpty(Object... obj) {
        boolean result = false;
        for (Object tmp : obj) {
            if (tmp instanceof String && !StringUtils.isEmpty((String) tmp)) {
                return true;
            } else if (tmp != null) {
                return true;
            }
        }
        return result;
    }

    /**
     * 得到当前年份（4位）
     * @author wuye
     * Date: 2017年10月12日 下午2:57:03
     * @return
     */
    public static int getYear() {
        return Calendar.getInstance().get(Calendar.YEAR);
    }

    /**
     * 获取Date类型，输入可以是int，long，Date，String，默认null
     * @author wuye
     * Date: 2017年9月27日 下午12:17:43
     * @param obj，String格式可以为 yyyy-MM-dd HH:mm:ss，yyyy-MM-dd HH:mm，yyyy-MM-dd
     * @return
     */
    public static Date getDate(Object obj) {
        Date time = null;
        if (obj == null) {
            return time;
        }
        if (obj instanceof Long || obj instanceof Integer) {
            Date dt = new Date(Long.parseLong(obj.toString()));
            time = dt;
        } else if (obj instanceof Date) {
            time = (Date) obj;
        } else if (obj instanceof String) {
            String str = (String) obj;
            SimpleDateFormat _sdf = sdf;
            if (str.length() == 16) {
                _sdf = sdf1;
            } else if (str.length() == 10) {
                _sdf = sdf2;
            }
            try {
                time = _sdf.parse(str);
            } catch (Exception e) {
            }
        }
        return time;
    }

    /**
     * 得到 逗号分隔的字符串
     * @author wuye
     * Date: 2016年10月13日 上午10:24:17
     * @param set Set<Integer>
     * @return
     */
    public static String getStrFromSet(Set<Integer> set) {
        String result = null;
        if (set != null && set.size() > 0) {
            StringBuilder sb = new StringBuilder("");
            for (Integer id : set) {
                sb.append(id + ",");
            }
            result = sb.substring(0, sb.length() - 1);
        }
        return result;
    }

    /**
     * 得到 逗号分隔的字符串
     * @author xuye
     * Date: 2018年7月31日 上午10:07:39
     * @param list
     * @return
     */
    public static String getStrFromList(List<Integer> list) {
        String result = null;
        if (list != null && list.size() > 0) {
            StringBuilder sb = new StringBuilder("");
            for (Integer id : list) {
                sb.append(id + ",");
            }
            result = sb.substring(0, sb.length() - 1);
        }
        return result;
    }

    /**
     * 获取时间字符串，输入可以是int，long，Date
     * @author wuye
     * Date: 2017年5月12日 下午3:30:43
     * @param obj
     * @return
     */
    public static String getTimeStr(Object obj) {
        String time;
        if (obj == null) {
            return "";
        }
        if (obj instanceof Long || obj instanceof Integer) {
            Date dt = new Date(Long.parseLong(obj.toString()));
            time = sdf.format(dt);
        } else if (obj instanceof Date) {
            time = sdf.format(obj);
        } else {
            time = obj.toString();
        }
        return time;
    }

    @SneakyThrows
    public static Map<Integer, Object> convertMap(List list) {
        Map<Integer, Object> map = new HashMap<>();
        for (Object obj : list) {
            Integer id = (Integer) obj.getClass().getDeclaredMethod("getId", null)
                    .invoke(obj, null);
            map.put(id, obj);
        }
        return map;
    }

    public static boolean isListAvali(List list) {
        if(list==null||list.size()==0){
            return false;
        }
        return true;
    }

    /**
     * @Author: xuye
     * @Description: 批量转换实体类
     * @Date: 2018/11/30 10:55
     * @param fromList
     * @param tClass
     * @return java.util.List<T>
     * @throws
     */
    public static<F,T> List<T> entityListToModelList(List<F> fromList, Class<T> tClass){
        if(!isListAvali(fromList)){
            return new ArrayList<>();
        }
        List<T> tList = new ArrayList<>();
        for(F f : fromList){
            T t = entityToModel(f, tClass);
            tList.add(t);
        }
        return tList;
    }
    
    /**
     * page类转换
     * @Author: xuye
     * @Date: 2019/8/9 13:20
     * @param oriPage
     * @param tClass
     * @return com.github.pagehelper.PageInfo<T>
     * @throws 
     */
    public static<F,T> PageInfo<T> entityPageToModelPage(PageInfo<F> oriPage,Class<T> tClass){
        PageInfo<T> pageInfo = new PageInfo<>();
        BeanUtils.copyProperties(oriPage,pageInfo,"list");
        if(isListAvali(oriPage.getList())){
            List<T> ts = entityListToModelList(oriPage.getList(), tClass);
            pageInfo.setList(ts);
        }
        return pageInfo;
    }

    public static<F,T> T entityToModel(F entity, Class<T> modelClass) {
        Object model = null;
        if (entity == null || modelClass ==null) {
            return null;
        }
        try {
            model = modelClass.newInstance();
        } catch (InstantiationException e) {
            Log4jKit.error("entityToModel : 实例化异常", e);
        } catch (IllegalAccessException e) {
            Log4jKit.error("entityToModel : 安全权限异常", e);
        }
        BeanUtils.copyProperties(entity, model);
        return (T)model;
    }









}