package com.ifourthwall.dbm.estate.facade.dto;

import com.ifourthwall.dbm.estate.facade.util.CheckRegexpUtils;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @Author: YangPeng
 * @Date: 2019/8/26 13:47
 * @Description:
 */
@Data
public class insertMerchantDTO implements Serializable {

    @ApiModelProperty(value = "不动产id")
    private String estateId;

    @ApiModelProperty(value = "类型（1：新增 2：修改）")
    @NotNull(message = "类型不能为空")
    private Integer type;

    @ApiModelProperty(value = "不动产类型（1:商户，2：住户）")
    @NotNull(message = "不动产类型不能为空")
    private Integer estateCategory;

    @ApiModelProperty(value = "项目id")
    @NotNull(message = "项目id不能为空")
    private Integer projectId;

    @ApiModelProperty(value = "企业名称")
    @NotNull(message = "企业名称不能为空")
    @Length(min = 1,max = 20,message = "企业名称长度不规范")
    private String estateName;

    @NotNull(message = "企业类型不能为空")
    @ApiModelProperty(value = "企业类型（1.商铺 2. 餐饮 3.办公 4.工作室 5.办事处 6.其他）")
    private Integer merchantType;

    @ApiModelProperty(value = "企业位置")
    @NotNull(message = "企业位置不能为空")
    @Length(min = 1,max = 20,message = "企业位置长度不规范")
    private String merchantArea;

    @ApiModelProperty(value = "企业规模")
    private Integer merchantScale;

    @NotNull(message = "企业联系人不能为空")
    @Length(min = 1,max = 10,message = "企业联系人长度不规范")
    @ApiModelProperty(value = "企业联系人")
    private String chargeName;

    @NotNull(message = "联系方式不能为空")
    @Length(min = 11,max = 11, message = "联系方式不规范")
    @Pattern(regexp = CheckRegexpUtils.REG_NUMBER, message = "联系方式不规范")
    @ApiModelProperty(value = "联系方式")
    private String chargePhone;

    @ApiModelProperty(value = "营业执照")
    private String businessLicense;

    @ApiModelProperty(value = "企业照片")
    private String merchantPic;

    @Length(max = 18, message = "统一社会信用代码不规范")
    @ApiModelProperty(value = "统一社会信用代码")
    private String socialCode;

    @Length(max =5,message = "法人长度最多5字符")
    @ApiModelProperty(value = "法人")
    private String legalPer;

    @Length(max = 30,message = "注册地址长度最多30个字符")
    @ApiModelProperty(value = " 注册地址")
    private String registerAddress;

    @Length(max = 11, message = "法人联系方式长度不规范")
    @Pattern(regexp = CheckRegexpUtils.REG_NUMBER, message = "法人联系方式长度不规范")
    @ApiModelProperty(value = "法人联系方式")
    private String legalPhone;

    @ApiModelProperty(value = "有效期限")
    private Date validDate;

    @Length(max = 200,message = "经营范围长度最多200字符")
    @ApiModelProperty(value = "经营范围")
    private String businessScope;

    @ApiModelProperty(value = "法人身份证件")
    private String idCardPic;

    @ApiModelProperty(value = "空间id")
    private List<Integer> spaceId;

    private Integer updateBy;


}
