package com.ifourthwall.dbm.estate.facade.dto;

import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @Author: xuye
 * @Date: 2019/9/3 13:50
 * @Description:
 */
@Data
public class OwnerRegisterQueryDTO implements Serializable {

    /**
     * 不动产id
     */
    @NotNull(message = "不动产id不能为空")
    private String estateId;

    /**
     * 业主名称
     */
    @NotNull(message = "业主名称不能为空")
    private String ownerName;

    /**
     * 业主手机
     */
    @NotNull(message = "业主手机不能为空")
    private String ownerPhone;

    /**
     * 申请时填的地址
     */
    @NotNull(message = "地址不能为空")
    private String applyAddr;

    /**
     * 申请时上传的图片，多个逗号隔开
     */
    private String applyPics;

    /**
     * 业主userId
     */
    @NotNull(message = "业主userId不能为空")
    private Integer ownerUserId;



}
