package com.ifourthwall.dbm.estate.facade.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @Author: xuye
 * @Date: 2019/9/3 19:17
 * @Description:
 */
@Data
public class OwnerIdentityDetailQueryDTO extends PageCommonDTO implements Serializable {

    /**
     * 业主id
     */
    private String ownerId;

    /**
     * 身份id
     */
    private String ownerIdentityId;

    /**
     * 状态(-1：删除，0：无效，1：正常)
     */
    private Integer valid;

    /**
     * 不动产ids
     */
    private List<String> estateIds;

    /**
     * 项目id
     */
    private Integer projectId;

    /**
     * 审核状态(1:待审核，2：审核通过，3：审核不通过)
     */
    private List<Integer> inExamineStatus;

    /**
     * 是否需要GroupByOwnerId
     * 0不需要，1需要
     */
    private Integer needGroupByOwnerId;

    /**
     * 最后一次申请的姓名模糊搜索
     */
    private String lastOwnerNameLike;



}
