package com.ifourthwall.dbm.estate.facade.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @Author: xuye
 * @Date: 2019/8/27 10:18
 * @Description:
 */
@Data
public class OwnerIdentityBaseDTO implements Serializable {

    /**
     * 流水号
     */
    private Long id;

    /**
     * 主键id
     */
    private String ownerIdentityId;

    /**
     * 状态(-1：删除，0：无效，1：正常)
     */
    private Integer valid;

    /**
     * 业主id
     */
    private String ownerId;

    /**
     * 不动产id
     */
    private String estateId;

    /**
     * 审核状态(1:待审核，2：审核通过，3：审核不通过)
     */
    private Integer examineStatus;

    /**
     * 申请时填的姓名
     */
    private String ownerName;

    /**
     * 申请时填的电话
     */
    private String ownerPhone;

    /**
     * 申请时填的地址
     */
    private String applyAddr;

    /**
     * 申请时上传的图片，多个逗号隔开
     */
    private String applyPics;

    /**
     * 创建时间
     */
    private Date createAt;

    /**
     * 创建人id
     */
    private Integer createBy;

    /**
     * 更新时间
     */
    private Date updateAt;

    /**
     * 更新人id
     */
    private Integer updateBy;
}
