package com.ifourthwall.dbm.estate.facade.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @Author: YangPeng
 * @Date: 2019/9/29 16:13
 * @Description:
 */
@Data
public class MerchantInfoSeerDTO implements Serializable {

    @ApiModelProperty(value = "不动产id")
    private String estateId;

    @ApiModelProperty(value = "空间id")
    private List<Integer> spaceId;

    @ApiModelProperty(value = "不动产名字")
    private String estateName;

/*    @ApiModelProperty(value = "住宅位置")
    private String ownerAddr;*/


    @ApiModelProperty(value = "企业照片")
    private String merchantPic;

    @ApiModelProperty(value = "商户类型（1.商铺 2. 餐饮 3.办公 4.工作室 5.办事处 6.其他）")
    private String merchantType;

    @ApiModelProperty(value = "建筑面积")
    private BigDecimal buildingArea;

    @ApiModelProperty(value = "业主姓名")
    private String chargeName;

    @ApiModelProperty(value = "手机号")
    private String chargePhone;

    @ApiModelProperty(value = "有效期限")
    private Date validDate;

    @ApiModelProperty(value = "法人联系方式")
    private String legalPhone;

    @ApiModelProperty(value = "注册地址")
    private String registerAddress;

    @ApiModelProperty(value = "法人")
    private String legalPer;

    @ApiModelProperty(value = "统一社会信用代码")
    private String socialCode;

    @ApiModelProperty(value = "营业执照")
    private String businessLicense;

    @ApiModelProperty(value = "身份列表")
    private List<OwnerIdentityDetailDTO> ownerList;

    @ApiModelProperty(value = "账单列表")
    private List<EstateBillListDTO> billList;



}
