package com.ifourthwall.dbm.estate.facade.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @Author: YangPeng
 * @Date: 2019/8/9 13:16
 * @Description:
 */
@Data
public class MerchantInfoDTO implements Serializable {

    @ApiModelProperty(value = " 商户id")
    private String estateId;

    @ApiModelProperty(value = " 企业名称")
    private String estateName;

    @ApiModelProperty("所属项目")
    private String projectName;

    @ApiModelProperty(value = " 企业类型（1.商铺 2. 餐饮 3.办公 4.工作室 5.办事处 6.其他）")
    private Integer merchantType;

    @ApiModelProperty(value = " 企业位置")
    private String merchantArea;

    @ApiModelProperty(value = " 企业规模")
    private Integer merchantScale;

    @ApiModelProperty(value = " 企业联系人")
    private String chargeName;

    @ApiModelProperty(value = " 联系方式")
    private String chargePhone;

    @ApiModelProperty(value = " 营业执照")
    private String businessLicense;

    @ApiModelProperty(value = " 企业照片")
    private String merchantPic;

    @ApiModelProperty(value = " 统一社会信用代码")
    private String socialCode;

    @ApiModelProperty(value = " 法人")
    private String legalPer;

    @ApiModelProperty(value = " 注册地址")
    private String registerAddress;

    @ApiModelProperty(value = " 法人联系方式")
    private String legalPhone;

    @ApiModelProperty(value = " 有效期限")
    private Date validDate;

    @ApiModelProperty(value = " 经营范围")
    private String businessScope;

    @ApiModelProperty(value = " 法人身份证件")
    private String idCardPic;


}
