package com.ifourthwall.dbm.estate.facade.dto;

import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @Author: xuye
 * @Date: 2019/9/12 16:52
 * @Description:
 */
@Data
public class EstateUpdateQueryDTO implements Serializable {

    /**
     * 流水号
     */
    @NotNull(message = "id不能为空")
    private Long id;

    /**
     * 状态 （-1：删除，0：无效，1：正常）
     */
    private Integer valid;

    /**
     * 不动产名称
     */
    private String estateName;

    /**
     * 负责人名称
     */
    private String chargeName;

    /**
     * 负责人联系方式
     */
    private String chargePhone;

    /**
     * 负责人身份证
     */
    private String chargeIdCard;

    /**
     * 住宅类型更新
     */
    private EstateResidenceUpdateQueryDTO residenceUpdateQuery;

    private Integer userId;



}
