package com.ifourthwall.dbm.estate.facade.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @Author: xuye
 * @Date: 2019/8/23 14:39
 * @Description:
 */
@Data
public class EstateSpaceDTO implements Serializable {

    /**
     * 流水号
     */
    private Long id;

    /**
     * 主键id
     */
    private String estateId;

    /**
     * 状态 （-1：删除，0：无效，1：正常）
     */
    private Integer valid;

    /**
     * 不动产类型（1:商户，2：住户）
     */
    private Integer estateCategory;

    /**
     * 项目id
     */
    private Integer projectId;

    /**
     * 不动产名称
     */
    private String estateName;

    /**
     * 负责人名称
     */
    private String chargeName;

    /**
     * 负责人联系方式
     */
    private String chargePhone;

    /**
     * 负责人身份证
     */
    private String chargeIdCard;

    private Date createAt;

    private Integer createBy;

    private Date updateAt;

    private Integer updateBy;

    //空间id
    private Integer spaceId;

}
