package com.ifourthwall.dbm.estate.facade.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @Author: xuye
 * @Date: 2019/9/26 14:25
 * @Description:
 */
@Data
public class EstateSeerListQueryDTO extends PageCommonDTO  implements Serializable {

    @ApiModelProperty("项目id")
    @NotNull(message = "项目id不能为空")
    private Integer projectId;

    @ApiModelProperty("不动产类型（1:商户，2：住户）")
    private Integer estateCategory;

    @ApiModelProperty("不动产名称模糊搜索")
    private String estateNameLike;

    @ApiModelProperty("账单状态1已缴，2待缴，3逾期")
    private Integer bizBillStatus;

    @ApiModelProperty("不动产id")
    private List<Integer> estateIds;
}
