package com.ifourthwall.dbm.estate.facade.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @Author: yangpeng
 * @Date: 2019/8/27 09:54
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class EstateReviewInfoDTO implements Serializable {

    @ApiModelProperty(value = "业主身份id")
    @NotNull(message = "业主身份id不能为空")
    private String ownerIdentityId;

    @ApiModelProperty(value = "审核信息")
    private String examineContent;

    @ApiModelProperty(value = "审核状态,（0不通过 1通过）")
    @NotNull(message = "审核状态不能为空")
    private Integer examineStatus;

    @ApiModelProperty(value = "创建人id")
    @NotNull(message = "创建人id不能为空")
    private Integer createBy;

}
