package com.ifourthwall.dbm.estate.facade.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @Author: yangpeng
 * @Date: 2019/8/27 09:54
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class EstateRelOwnerListDTO extends PageCommonDTO  {

    /**
     * 项目id
     */
    @NotNull(message = "projectId不能为空")
    private Integer projectId;

    /**
     * 不动产类型（1：商户；2：住户）
     */
    private Integer estateCategory;

    @ApiModelProperty(value = "搜索输入")
    private String search;
}
