package com.ifourthwall.dbm.estate.facade.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
/**
 *
 * @Author: YangPeng
 * @Date: 2019/9/4 17:45
 * @throws
 */
@Data
public class EstatePropertyDTO implements Serializable {

    @ApiModelProperty(value = "住宅位置")
    private String ownerAddr;

    @ApiModelProperty(value = "住宅名称")
    private String estateName;

    @ApiModelProperty(value = "住宅规格")
    private String residenceCategory;

    @ApiModelProperty(value = "建筑面积")
    private BigDecimal buildingArea;

    @ApiModelProperty(value = "使用面积")
    private BigDecimal usingArea;

    @ApiModelProperty(value = "公用面积")
    private BigDecimal publicArea;

    @ApiModelProperty(value = "业主姓名")
    private String chargeName;

    @ApiModelProperty(value = "身份证号")
    private String chargeIdCard;
}