package com.ifourthwall.dbm.estate.facade.dto;

import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;

@Data
@ToString(callSuper = true)
public class EstateMerchantDTO implements Serializable {
    /**
    * 流水号
     */
    private Long id;

    /**
    * 主键id
     */
    private String estateMerchantId;

    /**
    * 不动产id
     */
    private String estateId;

    /**
    * 商户类型（1.商铺 2. 餐饮 3.办公 4.工作室 5.办事处 6.其他），对应字典表：estate_merchant_type
     */
    private Integer merchantType;

    /**
    * 商户位置
     */
    private String merchantArea;

    /**
    * 商户规模
     */
    private Integer merchantScale;

    /**
    * 营业执照
     */
    private String businessLicense;

    /**
    * 企业照片
     */
    private String merchantPic;

    /**
    * 统一社会信用代码
     */
    private String socialCode;

    /**
    * 法人
     */
    private String legalPer;

    /**
    * 注册地址
     */
    private String registerAddress;

    /**
    * 法人联系方式
     */
    private String legalPhone;

    /**
    * 有效期限
     */
    private Date validDate;

    /**
    * 经营范围
     */
    private String businessScope;

    /**
    * 法人身份证件
     */
    private String idCardPic;
}