package com.ifourthwall.dbm.estate.facade.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;

/**
 * @Author: xuye
 * @Date: 2019/9/27 17:19
 * @Description:
 */
@Data
public class EstateBillSummaryQueryDTO implements Serializable {

    @ApiModelProperty("项目id")
    @NotNull(message = "项目id不能为空")
    private Integer projectId;

    @ApiModelProperty("不动产类型（1商户，2住宅）")
    private Integer estateCategory;

    @ApiModelProperty("需要支付的开始时间")
    private Date needPayDtStart;

    @ApiModelProperty("需要支付的结束时间")
    private Date needPayDtEnd;

}
