package com.ifourthwall.dbm.estate.facade.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Author: xuye
 * @Date: 2019/8/28 11:34
 * @Description:
 */
@Data
public class EstateBillInsertQueryDTO implements Serializable {

    @ApiModelProperty(value = "不动产id")
    @NotNull(message = "不动产id不能为空")
    private String estateId;

    @ApiModelProperty(value = "账单类型(1租赁费，2物业费，3水费，4电费，5煤气费，6公摊费，7其他)，对应字典表estate_bill_category")
    @NotNull(message = "账单类型不能为空")
    private Integer billCategory;

    @ApiModelProperty(value = "账单标题")
    @NotNull(message = "账单类型不能为空")
    private String billTitle;

    @ApiModelProperty(value = "账单备注")
    private String billRemark;

    @ApiModelProperty(value = "收费项1")
    private BigDecimal param1;

    @ApiModelProperty(value = "收费项2")
    private BigDecimal param2;

    @ApiModelProperty(value = "应收金额")
    @NotNull(message = "应收金额不能为空")
    private BigDecimal amount;

    @ApiModelProperty(value = "应缴日期")
    @NotNull(message = "应缴日期不能为空")
    private Date needPayDt;

    @ApiModelProperty(value = "操作人id")
    @NotNull(message = "操作人id不能为空")
    private Integer userId;
}
