package com.ifourthwall.dbm.estate.facade.dto;

import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@Data
@ToString(callSuper = true)
public class EstateBillBaseUpdateQueryDTO implements Serializable {
    /**
    * 流水号
     */
    @NotNull(message = "流水号不能为空")
    private Long id;

    /**
    * 收费项1
     */
    private BigDecimal param1;

    /**
    * 收费项2
     */
    private BigDecimal param2;

    /**
    * 应收金额
     */
    @NotNull(message = "应收金额不能为空")
    private BigDecimal amount;

    /**
    * 应缴日期
     */
    @NotNull(message = "应缴日期不能为空")
    private Date needPayDt;

    /**
     * 操作人id
     */
    @NotNull(message = "操作人id不能为空")
    private Integer userId;

}