package com.ifourthwall.dbm.estate.facade.dto;

import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @Author: xuye
 * @Date: 2019/8/29 19:25
 * @Description:
 */
@Data
public class BillPaymentWechatInsertQueryDTO  implements Serializable {

    /**
     * 账单目标类型，1业主账单
     */
    @NotNull(message = "账单目标类型，1业主账单")
    private Integer billTargetType;

    /**
     * 账单目标id
     */
    @NotNull(message = "账单目标id")
    private String billTargetId;

    /**
     * 付款人id(空表示不是用户付的)
     */
    private Integer userId;

    /**
     * 需要支付金额
     */
    private BigDecimal needPaymentAmount;

    /**
     * 操作人id
     */
    private Integer actionUserId;


}
