package com.ifourthwall.dbm.estate.facade.dto;

import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@Data
@ToString(callSuper = true)
public class BillPaymentBaseDTO implements Serializable {
    /**
     *
     */
    private Long id;

    /**
     * 主键id
     */
    private String billPaymentId;

    /**
     * 账单状态(1:待支付，2:已支付)
     */
    private Integer billStatus;

    /**
     * 支付渠道(1:线上，2线下)
     */
    private Integer paymentChannel;

    /**
     * 支付方式(1微信，2支付宝，3现金，4银行卡)
     */
    private Integer paymentCategory;

    /**
     * 账单目标类型，1业主账单
     */
    private Integer billTargetType;

    /**
     * 账单目标id
     */
    private String billTargetId;

    /**
     * 付款人id(空表示不是用户付的)
     */
    private Integer userId;

    /**
     * 需要支付金额
     */
    private BigDecimal needPaymentAmount;

    /**
     * 实际支付金额
     */
    private BigDecimal actualPaymentAmount;

    /**
     * 支付时间
     */
    private Date paymentAt;

    /**
     * 支付系序列号(交易号)
     */
    private String paymentNo;

    /**
     * 支付报文
     */
    private String paymentData;

    /**
     * 支付图片（用户上传的图片）
     */
    private String paymentPics;

    /**
     * 创建时间
     */
    private Date createAt;

    /**
     * 创建人id
     */
    private Integer createBy;

    /**
     * 更新时间
     */
    private Date updateAt;

    /**
     * 更新人id
     */
    private Integer updateBy;
}