package com.ifourthwall.dbm.estate.facade;

import com.github.pagehelper.PageInfo;
import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.dbm.estate.facade.dto.CommonIdUserIdQueryDTO;
import com.ifourthwall.dbm.estate.facade.dto.OwnerIdentityDetailDTO;
import com.ifourthwall.dbm.estate.facade.dto.OwnerIdentityDetailQueryDTO;
import lombok.extern.slf4j.Slf4j;

/**
 * @Author: xuye
 * @Date: 2019/9/3 20:07
 * @Description:
 */
public interface OwnerIdentityFacade {

    /**
     * 查询身份信息列表
     * @Author: xuye
     * @Date: 2019/9/3 19:23
     * @param query
     * @return com.github.pagehelper.PageInfo<com.ifourthwall.dbm.estate.bo.OwnerIdentityDetailBO>
     * @throws
     */
    BaseResponse<PageInfo<OwnerIdentityDetailDTO>> listDetail(OwnerIdentityDetailQueryDTO query);

    /**
     * 删除身份
     * @Author: xuye
     * @Date: 2019/9/4 16:27
     * @param query
     * @return com.ifourthwall.common.base.BaseResponse<java.lang.Integer>
     * @throws
     */
    BaseResponse<Integer> delIdentity(CommonIdUserIdQueryDTO query);
}
