package com.ifourthwall.dbm.estate.facade;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.dbm.estate.facade.dto.OwnerProjectIdQueryDTO;
import com.ifourthwall.dbm.estate.facade.dto.OwnerProjectIdsDTO;
import com.ifourthwall.dbm.estate.facade.dto.OwnerRegisterQueryDTO;

import java.util.List;

/**
 * @Author: xuye
 * @Date: 2019/9/4 19:06
 * @Description:
 */
public interface OwnerFacade {

    /**
     * 业主注册，会添加对应的身份
     * @Author: xuye
     * @Date: 2019/9/3 15:05
     * @param query
     * @return java.lang.Integer
     * @throws
     */
    BaseResponse<Integer> insertRegister(OwnerRegisterQueryDTO query);

    /**
     * 获取用户对应身份的项目集合
     * @Author: xuye
     * @Date: 2019/9/3 16:15
     * @param query
     * @return java.util.List<java.lang.Integer>
     * @throws
     */
    BaseResponse<OwnerProjectIdsDTO> listOwnerProjectId(OwnerProjectIdQueryDTO query);

}
