package com.ifourthwall.dbm.estate.facade;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.dbm.estate.facade.dto.*;

import java.util.List;

/**
 * @Author: xuye
 * @Date: 2019/8/31 11:49
 * @Description:
 */
public interface EstateMerchantFacade {

    /**
     * 根据不动产id查询商户信息
     * @Author: YangPeng
     * @Date: 2019/9/18 14:52
     * @param ids
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.estate.facade.dto.EstateMerchantDTO>
     * @throws
     */
    BaseResponse<List<EstateMerchantDTO>> queryMerchantList(EstateMerchantQueryDTO ids);

    /**
     * 查询seer端商户列表
     * @Author: YangPeng
     * @Date: 2019/9/29 16:47
     * @param listquery
     * @return com.ifourthwall.common.base.BaseResponse<java.util.List<com.ifourthwall.dbm.estate.facade.dto.MerchantListSeerDTO>>
     * @throws
     */
    BaseResponse<List<MerchantListSeerDTO>> seerMerchantList(MerchantListSeerQueryDTO listquery);

    /**
     * seer端查询商户详情
     * @Author: YangPeng
     * @Date: 2019/9/30 10:00
     * @param infoSeerQueryDTO
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.estate.facade.dto.MerchantInfoSeerDTO>
     * @throws
     */
    BaseResponse<MerchantInfoSeerDTO> seerQueryMerchant(MerchantInfoSeerQueryDTO infoSeerQueryDTO);

}
