package com.ifourthwall.dbm.estate.facade;

import com.github.pagehelper.PageInfo;
import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.dbm.estate.facade.dto.*;

import java.util.List;

/**
 * @Author: xuye
 * @Date: 2019/8/23 14:43
 * @Description:
 */
public interface EstateFacade {


    BaseResponse<EstateDTO> getById(CommonIdDTO idDTO);

    /**
     * 插入住户
     *
     * @param residenceDTO
     * @return java.lang.Integer
     * @throws
     * @Author: YangPeng
     * @Date: 2019/8/26 14:12
     */
    BaseResponse<Integer> insertResidence(ResidenceDTO residenceDTO);

    /**
     * 查询住户列表
     *
     * @param queryDTO
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.estate.facade.dto.EstateListDTO>
     * @throws
     * @Author: YangPeng
     * @Date: 2019/8/27 16:23
     */
    BaseResponse<PageInfo<EstateListDTO>> queryResidenceList(EstateRelOwnerListDTO queryDTO);


    /**
     * 查根据不动产id询商户信息
     *
     * @param id
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.estate.facade.dto.EstateMerchantDTO>
     * @throws
     * @Author: YangPeng
     * @Date: 2019/9/2 16:54
     */
    BaseResponse<EstateMerchantDTO> queryMerchant(MerchantDTO id);

    /**
     * 新增/修改商户信息
     * @Author: YangPeng
     * @Date: 2019/9/10 13:38
     * @param insert
     * @return com.ifourthwall.common.base.BaseResponse<java.lang.Integer>
     * @throws
     */
    BaseResponse<Integer> upInsertMerchant(insertMerchantDTO insert);

    /**
     * 查询不动产关联住宅及商户信息
     * @Author: xuye
     * @Date: 2019/9/12 13:22
     * @param
     * @return java.util.List<com.ifourthwall.dbm.estate.bo.EstateResidenceMerchantBO>
     * @throws
     */
    BaseResponse<List<EstateResidenceMerchantDTO>> listResidenceMerchant(EstateResidenceMerchantQueryDTO queryBO);

    /**
     * 更新不动产信息
     *
     * @param query
     * @return java.lang.Integer
     * @throws
     * @Author: xuye
     * @Date: 2019/9/14 9:15
     */
    BaseResponse<Integer> updateEstate(EstateUpdateQueryDTO query);

    /**
     * 查询不动产（商户详情）
     * @Author: YangPeng
     * @Date: 2019/9/16 13:39
     * @param query
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.estate.facade.dto.MerchantInfoDTO>
     * @throws
     */
    BaseResponse<MerchantInfoDTO> queryMerchantInfo(MerchantInfoQuyeryDTO query);

    /**
     * 删除不动产
     * @Author: YangPeng
     * @Date: 2019/9/18 17:01
     * @param delete
     * @return com.ifourthwall.common.base.BaseResponse<java.lang.Integer>
     * @throws
     */
    BaseResponse<Integer> deleteEstate(DeleteEstateQueryDTO delete);

    /**
     * 根据项目id查询不动产信息
     * @Author: YangPeng
     * @Date: 2019/9/20 16:57
     * @param query
     * @return com.ifourthwall.common.base.BaseResponse<java.util.List<com.ifourthwall.dbm.estate.facade.dto.EstateDTO>>
     * @throws
     */
    BaseResponse<List<EstateDTO>> queryEstateList(EstateListQuyeryDTO query);

    /**
     * 获取不动产列表，关联账单状态
     * @Author: xuye
     * @Date: 2019/9/26 14:29
     * @param query
     * @return java.util.List<com.ifourthwall.dbm.estate.bo.EstateSeerListBO>
     * @throws
     */
    BaseResponse<PageInfo<EstateSeerListDTO>> getEstateSeerList(EstateSeerListQueryDTO query);

    /**
     * 获取不动产对应数量
     * @Author: xuye
     * @Date: 2019/9/28 14:14
     * @param query
     * @return com.ifourthwall.dbm.estate.bo.EstateCategoryCountBO
     * @throws
     */
    BaseResponse<EstateCategoryCountDTO> getEstateCategoryCount(EstateCategoryCountQueryDTO query);
}
