/*
 * Decompiled with CFR 0.152.
 */
package com.github.zengfr.easymodbus4j.codec.tcp;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;

public class ModbusTcpLFBFrameDecoder
extends LengthFieldBasedFrameDecoder {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ModbusTcpLFBFrameDecoder.class);
    private boolean skipUnknowBytes = false;

    public ModbusTcpLFBFrameDecoder(boolean skipUnknowBytes) {
        super(260, 4, 2);
        this.skipUnknowBytes = skipUnknowBytes;
    }

    public ModbusTcpLFBFrameDecoder() {
        this(false);
    }

    protected Object decode(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
        if (this.skipUnknowBytes) {
            boolean skip = false;
            int i = in.readableBytes();
            if (i < 8) {
                skip = true;
            }
            if (i > 260) {
                skip = true;
            }
            if (skip) {
                in.skipBytes(in.readableBytes());
                logger.debug(String.format("skip Bytes:%s;%s;", skip, i));
            }
        }
        Object decoded = super.decode(ctx, in);
        return decoded;
    }
}

