/*
 * Decompiled with CFR 0.152.
 */
package com.github.zengfr.easymodbus4j.codec.tcp;

import com.github.zengfr.easymodbus4j.func.request.ReadCoilsRequest;
import com.github.zengfr.easymodbus4j.func.request.ReadDiscreteInputsRequest;
import com.github.zengfr.easymodbus4j.func.request.ReadHoldingRegistersRequest;
import com.github.zengfr.easymodbus4j.func.request.ReadInputRegistersRequest;
import com.github.zengfr.easymodbus4j.func.request.WriteMultipleCoilsRequest;
import com.github.zengfr.easymodbus4j.func.request.WriteMultipleRegistersRequest;
import com.github.zengfr.easymodbus4j.func.request.WriteSingleCoilRequest;
import com.github.zengfr.easymodbus4j.func.request.WriteSingleRegisterRequest;
import com.github.zengfr.easymodbus4j.func.response.ErrorFunctionResponse;
import com.github.zengfr.easymodbus4j.func.response.ReadCoilsResponse;
import com.github.zengfr.easymodbus4j.func.response.ReadDiscreteInputsResponse;
import com.github.zengfr.easymodbus4j.func.response.ReadHoldingRegistersResponse;
import com.github.zengfr.easymodbus4j.func.response.ReadInputRegistersResponse;
import com.github.zengfr.easymodbus4j.func.response.WriteMultipleCoilsResponse;
import com.github.zengfr.easymodbus4j.func.response.WriteMultipleRegistersResponse;
import com.github.zengfr.easymodbus4j.func.response.WriteSingleCoilResponse;
import com.github.zengfr.easymodbus4j.func.response.WriteSingleRegisterResponse;
import com.github.zengfr.easymodbus4j.protocol.ModbusFunction;
import com.github.zengfr.easymodbus4j.protocol.tcp.ModbusFrame;
import com.github.zengfr.easymodbus4j.protocol.tcp.ModbusHeader;
import com.github.zengfr.easymodbus4j.util.ModbusFunctionUtil;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.List;

public class ModbusTcpDecoder
extends ByteToMessageDecoder {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ModbusTcpDecoder.class);
    private final boolean isSlave;

    public ModbusTcpDecoder(boolean isSlave) {
        this.isSlave = isSlave;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf buffer, List<Object> out) {
        logger.debug("decode");
        if (buffer.capacity() < 8) {
            return;
        }
        buffer.markReaderIndex();
        ModbusFrame frame = ModbusTcpDecoder.decodeFrame(buffer, this.isSlave);
        if (frame != null) {
            out.add(frame);
        } else {
            buffer.resetReaderIndex();
            ctx.fireChannelRead((Object)buffer);
        }
    }

    public static ModbusFrame decodeFrame(ByteBuf buffer, boolean isSlave) {
        if (buffer.capacity() < 8) {
            return null;
        }
        ModbusHeader mbapHeader = ModbusHeader.decode((ByteBuf)buffer);
        ModbusFunction function = ModbusTcpDecoder.decodeFunction(buffer, isSlave);
        ModbusFrame frame = new ModbusFrame(mbapHeader, function);
        return frame;
    }

    public static ModbusFunction decodeFunction(ByteBuf buffer, boolean isRequest) {
        ModbusFunction function = null;
        short functionCode = buffer.readUnsignedByte();
        function = isRequest ? ModbusTcpDecoder.decodeReqFunction(functionCode) : ModbusTcpDecoder.decodeRespFunction(functionCode);
        if (ModbusFunctionUtil.isError((short)functionCode)) {
            function = new ErrorFunctionResponse(functionCode);
        } else if (function == null) {
            function = new ErrorFunctionResponse(functionCode, 1);
        }
        function.decode(buffer.readBytes(buffer.readableBytes()));
        return function;
    }

    protected static ModbusFunction decodeReqFunction(short functionCode) {
        ReadCoilsRequest function = null;
        switch (functionCode) {
            case 1: {
                function = new ReadCoilsRequest();
                break;
            }
            case 2: {
                function = new ReadDiscreteInputsRequest();
                break;
            }
            case 4: {
                function = new ReadInputRegistersRequest();
                break;
            }
            case 3: {
                function = new ReadHoldingRegistersRequest();
                break;
            }
            case 5: {
                function = new WriteSingleCoilRequest();
                break;
            }
            case 6: {
                function = new WriteSingleRegisterRequest();
                break;
            }
            case 15: {
                function = new WriteMultipleCoilsRequest();
                break;
            }
            case 16: {
                function = new WriteMultipleRegistersRequest();
            }
        }
        return function;
    }

    public static ModbusFunction decodeRespFunction(short functionCode) {
        ReadCoilsResponse function = null;
        switch (functionCode) {
            case 1: {
                function = new ReadCoilsResponse();
                break;
            }
            case 2: {
                function = new ReadDiscreteInputsResponse();
                break;
            }
            case 4: {
                function = new ReadInputRegistersResponse();
                break;
            }
            case 3: {
                function = new ReadHoldingRegistersResponse();
                break;
            }
            case 5: {
                function = new WriteSingleCoilResponse();
                break;
            }
            case 6: {
                function = new WriteSingleRegisterResponse();
                break;
            }
            case 15: {
                function = new WriteMultipleCoilsResponse();
                break;
            }
            case 16: {
                function = new WriteMultipleRegistersResponse();
            }
        }
        return function;
    }
}

