/*
 * Decompiled with CFR 0.152.
 */
package com.github.zengfr.easymodbus4j.codec.tcp;

import com.github.zengfr.easymodbus4j.codec.ModbusPduCodec;
import com.github.zengfr.easymodbus4j.protocol.ModbusFunction;
import com.github.zengfr.easymodbus4j.protocol.tcp.ModbusFrame;
import com.github.zengfr.easymodbus4j.protocol.tcp.ModbusHeader;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageCodec;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.List;

public class ModbusTcpCodec
extends ByteToMessageCodec<ModbusFrame> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ModbusTcpCodec.class);
    private final ModbusPduCodec pduCodec;

    public ModbusTcpCodec(ModbusPduCodec pduCodec) {
        this.pduCodec = pduCodec;
    }

    protected void encode(ChannelHandlerContext ctx, ModbusFrame msg, ByteBuf out) throws Exception {
        logger.debug("encode");
        ctx.writeAndFlush((Object)msg.encode());
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        logger.debug("decode");
        ModbusHeader mbapHeader = ModbusHeader.decode((ByteBuf)in);
        ModbusFunction function = (ModbusFunction)this.pduCodec.decode(in);
        ModbusFrame frame = new ModbusFrame(mbapHeader, function);
        if (frame != null) {
            out.add(frame);
        }
    }
}

