/*
 * Decompiled with CFR 0.152.
 */
package com.github.zengfr.easymodbus4j.codec.rtu;

import com.github.zengfr.easymodbus4j.util.ModbusFunctionUtil;
import io.netty.buffer.ByteBuf;

public class ModbusRtuCodecUtil {
    private static final int MessageMinSize = 5;
    private static final int FunctionFieldIndex = 1;
    private static final int LengthFieldIndex = 2;

    public static int getMessageMinSize() {
        return 5;
    }

    private static int getLength(ByteBuf in, int startIndex) {
        return in.getUnsignedByte(startIndex + 2);
    }

    private static short getFunctionCode(ByteBuf in, int startIndex) {
        return in.getUnsignedByte(startIndex + 1);
    }

    public static int getMessageLength(ByteBuf in, int startIndex) {
        short functionCode = ModbusRtuCodecUtil.getFunctionCode(in, startIndex);
        if (ModbusFunctionUtil.isError((short)functionCode)) {
            return 5;
        }
        switch (functionCode) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                int length = ModbusRtuCodecUtil.getLength(in, startIndex);
                return 3 + length + 2;
            }
            case 5: 
            case 6: 
            case 15: 
            case 16: {
                return 8;
            }
        }
        return 0;
    }
}

