/*
 * Decompiled with CFR 0.152.
 */
package com.github.zengfr.easymodbus4j.codec.rtu;

import com.github.zengfr.easymodbus4j.codec.ModbusPduCodec;
import com.github.zengfr.easymodbus4j.codec.rtu.ModbusRtuCodecUtil;
import com.github.zengfr.easymodbus4j.common.util.RtuCrcUtil;
import com.github.zengfr.easymodbus4j.protocol.ModbusFunction;
import com.github.zengfr.easymodbus4j.protocol.tcp.ModbusFrame;
import com.github.zengfr.easymodbus4j.protocol.tcp.ModbusHeader;
import com.github.zengfr.easymodbus4j.util.ModbusTransactionIdUtil;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageCodec;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.List;

public class ModbusRtuCodec2
extends ByteToMessageCodec<ModbusFrame> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ModbusRtuCodec2.class);
    protected final ModbusPduCodec pduCodec;

    public ModbusRtuCodec2(ModbusPduCodec pduCodec) {
        this.pduCodec = pduCodec;
    }

    protected void encode(ChannelHandlerContext ctx, ModbusFrame msg, ByteBuf out) throws Exception {
        logger.debug("encode");
        ByteBuf sendBuf = ctx.alloc().heapBuffer(1 + (msg.getHeader().getLength() - 1) + 2);
        sendBuf.writeByte((int)msg.getHeader().getUnitIdentifier());
        sendBuf.writeBytes(msg.getFunction().encode());
        this.writeRtuCRC(sendBuf);
        ctx.writeAndFlush((Object)sendBuf);
    }

    private void writeRtuCRC(ByteBuf buffer) {
        int startReaderIndex = buffer.readerIndex();
        int crc = RtuCrcUtil.calculateCRC((ByteBuf)buffer);
        buffer.readerIndex(startReaderIndex);
        buffer.writeByte((int)((byte)(0xFF & crc >> 8)));
        buffer.writeByte((int)((byte)(0xFF & crc)));
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        logger.debug("decode");
        int startIndex = in.readerIndex();
        while (in.readableBytes() >= ModbusRtuCodecUtil.getMessageMinSize() && in.readableBytes() >= ModbusRtuCodecUtil.getMessageLength(in, startIndex)) {
            int pduLength;
            int protocolIdentifier;
            short unitId = in.readUnsignedByte();
            ModbusFunction function = (ModbusFunction)this.pduCodec.decode(in);
            int crc = in.readUnsignedShort();
            int transactionId = -ModbusTransactionIdUtil.calculateTransactionId();
            ModbusHeader mbapHeader = new ModbusHeader(transactionId, protocolIdentifier = 0, pduLength = function.calculateLength(), unitId);
            ModbusFrame frame = new ModbusFrame(mbapHeader, function);
            if (frame != null) {
                out.add(frame);
            }
            startIndex = in.readerIndex();
        }
    }
}

