/*
 * Decompiled with CFR 0.152.
 */
package com.github.zengfr.easymodbus4j.codec.rtu;

import com.github.zengfr.easymodbus4j.codec.ModbusPduCodec;
import com.github.zengfr.easymodbus4j.codec.rtu.ModbusRtuCodecUtil;
import com.github.zengfr.easymodbus4j.protocol.ModbusFunction;
import com.github.zengfr.easymodbus4j.protocol.rtu.ModbusRtuFrame;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageCodec;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.List;

public class ModbusRtuCodec
extends ByteToMessageCodec<ModbusRtuFrame> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ModbusRtuCodec.class);
    protected final ModbusPduCodec pduCodec;

    public ModbusRtuCodec(ModbusPduCodec pduCodec) {
        this.pduCodec = pduCodec;
    }

    protected void encode(ChannelHandlerContext ctx, ModbusRtuFrame msg, ByteBuf out) throws Exception {
        logger.debug("encode");
        out.writeBytes(msg.encode());
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        logger.debug("decode");
        int startIndex = in.readerIndex();
        while (in.readableBytes() >= ModbusRtuCodecUtil.getMessageMinSize() && in.readableBytes() >= ModbusRtuCodecUtil.getMessageLength(in, startIndex)) {
            short unitId = in.readUnsignedByte();
            ModbusFunction function = (ModbusFunction)this.pduCodec.decode(in);
            int crc = in.readUnsignedShort();
            ModbusRtuFrame frame = new ModbusRtuFrame(unitId, function);
            if (frame != null) {
                out.add(frame);
            }
            startIndex = in.readerIndex();
        }
    }
}

