/*
 * Decompiled with CFR 0.152.
 */
package com.github.zengfr.easymodbus4j.codec.ping;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.charset.Charset;
import java.util.List;

public class ModbusPingDecoder
extends MessageToMessageDecoder<ByteBuf> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ModbusPingDecoder.class);
    private final Charset charset;
    private final String heartBeat;

    public ModbusPingDecoder(String heartBeat, Charset charset) {
        if (charset == null || heartBeat == null) {
            throw new NullPointerException("heartBeat/charset");
        }
        this.heartBeat = heartBeat;
        this.charset = charset;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        in.retain();
        boolean success = false;
        int heartBeatByteLen = this.heartBeat.length() * 2;
        if (in.readableBytes() >= heartBeatByteLen) {
            byte[] headArray = new byte[heartBeatByteLen];
            in.markReaderIndex();
            in.readBytes(headArray);
            String head = new String(headArray, this.charset);
            success = this.heartBeat.equalsIgnoreCase(head);
            if (success) {
                out.add(head);
            } else {
                in.resetReaderIndex();
            }
        }
        logger.debug(String.format("decode isHeartBeat:%s", success));
        if (!success) {
            ctx.fireChannelRead((Object)in);
        }
    }
}

