/*
 * Decompiled with CFR 0.152.
 */
package com.github.zengfr.easymodbus4j.codec;

import com.github.zengfr.easymodbus4j.codec.ModbusPduCodec;
import com.github.zengfr.easymodbus4j.func.response.ErrorFunctionResponse;
import com.github.zengfr.easymodbus4j.func.response.ReadCoilsResponse;
import com.github.zengfr.easymodbus4j.func.response.ReadDiscreteInputsResponse;
import com.github.zengfr.easymodbus4j.func.response.ReadHoldingRegistersResponse;
import com.github.zengfr.easymodbus4j.func.response.ReadInputRegistersResponse;
import com.github.zengfr.easymodbus4j.func.response.WriteMultipleCoilsResponse;
import com.github.zengfr.easymodbus4j.func.response.WriteMultipleRegistersResponse;
import com.github.zengfr.easymodbus4j.func.response.WriteSingleCoilResponse;
import com.github.zengfr.easymodbus4j.func.response.WriteSingleRegisterResponse;
import com.github.zengfr.easymodbus4j.protocol.ModbusFunction;
import com.github.zengfr.easymodbus4j.util.ModbusFunctionUtil;
import io.netty.buffer.ByteBuf;

public class ModbusPduRespCodec
extends ModbusPduCodec {
    @Override
    public ModbusFunction decode(ByteBuf buffer) {
        return ModbusPduRespCodec.decodeFunction(buffer);
    }

    public static ModbusFunction decodeFunction(ByteBuf buffer) {
        short functionCode = buffer.readUnsignedByte();
        ModbusFunction function = ModbusPduRespCodec.decodeRespFunction(functionCode);
        if (ModbusFunctionUtil.isError((short)functionCode)) {
            function = new ErrorFunctionResponse(functionCode);
        } else if (function == null) {
            function = new ErrorFunctionResponse(functionCode, 1);
        }
        function.decode(buffer);
        return function;
    }

    protected static ModbusFunction decodeRespFunction(short functionCode) {
        ReadCoilsResponse function = null;
        switch (functionCode) {
            case 1: {
                function = new ReadCoilsResponse();
                break;
            }
            case 2: {
                function = new ReadDiscreteInputsResponse();
                break;
            }
            case 4: {
                function = new ReadInputRegistersResponse();
                break;
            }
            case 3: {
                function = new ReadHoldingRegistersResponse();
                break;
            }
            case 5: {
                function = new WriteSingleCoilResponse();
                break;
            }
            case 6: {
                function = new WriteSingleRegisterResponse();
                break;
            }
            case 15: {
                function = new WriteMultipleCoilsResponse();
                break;
            }
            case 16: {
                function = new WriteMultipleRegistersResponse();
            }
        }
        return function;
    }
}

