/*
 * Decompiled with CFR 0.152.
 */
package com.github.zengfr.easymodbus4j.codec;

import com.github.zengfr.easymodbus4j.codec.ModbusPduCodec;
import com.github.zengfr.easymodbus4j.func.request.ReadCoilsRequest;
import com.github.zengfr.easymodbus4j.func.request.ReadDiscreteInputsRequest;
import com.github.zengfr.easymodbus4j.func.request.ReadHoldingRegistersRequest;
import com.github.zengfr.easymodbus4j.func.request.ReadInputRegistersRequest;
import com.github.zengfr.easymodbus4j.func.request.WriteMultipleCoilsRequest;
import com.github.zengfr.easymodbus4j.func.request.WriteMultipleRegistersRequest;
import com.github.zengfr.easymodbus4j.func.request.WriteSingleCoilRequest;
import com.github.zengfr.easymodbus4j.func.request.WriteSingleRegisterRequest;
import com.github.zengfr.easymodbus4j.protocol.ModbusFunction;
import io.netty.buffer.ByteBuf;

public class ModbusPduReqCodec
extends ModbusPduCodec {
    @Override
    public ModbusFunction decode(ByteBuf buffer) {
        return ModbusPduReqCodec.decodeFunction(buffer);
    }

    public static ModbusFunction decodeFunction(ByteBuf buffer) {
        short functionCode = buffer.readUnsignedByte();
        ModbusFunction function = ModbusPduReqCodec.decodeReqFunction(functionCode);
        function.decode(buffer);
        return function;
    }

    protected static ModbusFunction decodeReqFunction(short functionCode) {
        ReadCoilsRequest function = null;
        switch (functionCode) {
            case 1: {
                function = new ReadCoilsRequest();
                break;
            }
            case 2: {
                function = new ReadDiscreteInputsRequest();
                break;
            }
            case 4: {
                function = new ReadInputRegistersRequest();
                break;
            }
            case 3: {
                function = new ReadHoldingRegistersRequest();
                break;
            }
            case 5: {
                function = new WriteSingleCoilRequest();
                break;
            }
            case 6: {
                function = new WriteSingleRegisterRequest();
                break;
            }
            case 15: {
                function = new WriteMultipleCoilsRequest();
                break;
            }
            case 16: {
                function = new WriteMultipleRegistersRequest();
            }
        }
        return function;
    }
}

