/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.github.zengfr.easymodbus4j.codec.tcp;

import com.github.zengfr.easymodbus4j.ModbusConsts;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;

/**
 * @author zengfr QQ:362505707/1163551688 Email:zengfr3000@qq.com
 *         https://github.com/zengfr/easymodbus4j
 */
public class ModbusTcpLFBFrameDecoder extends LengthFieldBasedFrameDecoder {
	private static final InternalLogger logger = InternalLoggerFactory.getInstance(ModbusTcpLFBFrameDecoder.class);
	private boolean skipUnknowBytes = false;

	public ModbusTcpLFBFrameDecoder(boolean skipUnknowBytes) {
		super(ModbusConsts.ADU_MAX_LENGTH, 4, 2);
		this.skipUnknowBytes = skipUnknowBytes;
	}

	public ModbusTcpLFBFrameDecoder() {
		this(false);
	}

	@Override
	protected Object decode(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
		if (skipUnknowBytes) {
			boolean skip = false;
			int i = in.readableBytes();
			if (i < ModbusConsts.MBAP_LENGTH + 1) {
				skip = true;
			}
			if (i > ModbusConsts.ADU_MAX_LENGTH) {
				skip = true;
			}
			if (skip) {
				in.skipBytes(in.readableBytes());
				logger.debug(String.format("skip Bytes:%s;%s;", skip, i));
			}
		}
		Object decoded = super.decode(ctx, in);
		return decoded;
	}

}
