/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.github.zengfr.easymodbus4j.codec.m2m;

import java.util.List;

import com.github.zengfr.easymodbus4j.ModbusConsts;
import com.github.zengfr.easymodbus4j.protocol.rtu.ModbusRtuFrame;
import com.github.zengfr.easymodbus4j.protocol.tcp.ModbusFrame;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
/**
 * @author zengfr QQ:362505707/1163551688 Email:zengfr3000@qq.com
 *         https://github.com/zengfr/easymodbus4j
 */
public class ModbusRtu2TcpCodec extends MessageToMessageCodec<ModbusRtuFrame, ModbusFrame> {

	@Override
	protected void encode(ChannelHandlerContext ctx, ModbusFrame msg, List<Object> out) throws Exception {
		ModbusRtuFrame frame = ModbusFrameConvertor.tcp2Rtu(msg);
		out.add(frame);
	}

	@Override
	protected void decode(ChannelHandlerContext ctx, ModbusRtuFrame msg, List<Object> out) throws Exception {
		int transactionId = -1;// TransactionIdentifierBuilder.calculateTransactionId();
		int protocolIdentifier = ModbusConsts.DEFAULT_PROTOCOL_IDENTIFIER;
		ModbusFrame frame = ModbusFrameConvertor.rtu2Tcp(msg, transactionId, protocolIdentifier);
		out.add(frame);
	}

}
