/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.github.zengfr.easymodbus4j.codec.m2m;

import com.github.zengfr.easymodbus4j.protocol.rtu.ModbusRtuFrame;
import com.github.zengfr.easymodbus4j.protocol.tcp.ModbusFrame;
import com.github.zengfr.easymodbus4j.protocol.tcp.ModbusHeader;
/**
 * @author zengfr QQ:362505707/1163551688 Email:zengfr3000@qq.com
 *         https://github.com/zengfr/easymodbus4j
 */
public class ModbusFrameConvertor {
	public static ModbusFrame rtu2Tcp(ModbusRtuFrame frame, int transactionId, int protocolIdentifier) {
		int pduLength = frame.getFunction().calculateLength();
		short unitId = frame.getUnitId();
		ModbusHeader header = new ModbusHeader(transactionId, protocolIdentifier, pduLength, unitId);
		ModbusFrame f = new ModbusFrame(header, frame.getFunction());
		return f;
	}

	public static ModbusRtuFrame tcp2Rtu(ModbusFrame frame) {
		short unitId = frame.getHeader().getUnitIdentifier();
		ModbusRtuFrame f = new ModbusRtuFrame(unitId, frame.getFunction());
		return f;
	}
}
