/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource.tx;

import com.baomidou.dynamic.datasource.tx.ConnectionProxy;
import com.baomidou.dynamic.datasource.tx.SavePointHolder;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.transaction.CannotCreateTransactionException;
import org.springframework.transaction.TransactionException;
import org.springframework.util.CollectionUtils;

public class ConnectionFactory {
    private static final ThreadLocal<Map<String, Map<String, ConnectionProxy>>> CONNECTION_HOLDER = new ThreadLocal<Map<String, Map<String, ConnectionProxy>>>(){

        @Override
        protected Map<String, Map<String, ConnectionProxy>> initialValue() {
            return new ConcurrentHashMap<String, Map<String, ConnectionProxy>>();
        }
    };
    private static final ThreadLocal<Map<String, List<SavePointHolder>>> SAVEPOINT_CONNECTION_HOLDER = new ThreadLocal<Map<String, List<SavePointHolder>>>(){

        @Override
        protected Map<String, List<SavePointHolder>> initialValue() {
            return new ConcurrentHashMap<String, List<SavePointHolder>>();
        }
    };

    public static void putConnection(String xid, String ds, ConnectionProxy connection) {
        Map<String, Map<String, ConnectionProxy>> concurrentHashMap = CONNECTION_HOLDER.get();
        Map<String, ConnectionProxy> connectionProxyMap = concurrentHashMap.get(xid);
        if (connectionProxyMap == null) {
            connectionProxyMap = new ConcurrentHashMap<String, ConnectionProxy>();
            concurrentHashMap.put(xid, connectionProxyMap);
        }
        if (!connectionProxyMap.containsKey(ds)) {
            try {
                connection.setAutoCommit(false);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            connectionProxyMap.put(ds, connection);
        }
    }

    public static ConnectionProxy getConnection(String xid, String ds) {
        Map<String, Map<String, ConnectionProxy>> concurrentHashMap = CONNECTION_HOLDER.get();
        Map<String, ConnectionProxy> connectionProxyMap = concurrentHashMap.get(xid);
        if (CollectionUtils.isEmpty(connectionProxyMap)) {
            return null;
        }
        return connectionProxyMap.get(ds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notify(String xid, Boolean state) throws Exception {
        block17: {
            SQLException exception = null;
            Map<String, Map<String, ConnectionProxy>> concurrentHashMap = CONNECTION_HOLDER.get();
            Map<String, List<SavePointHolder>> savePointMap = SAVEPOINT_CONNECTION_HOLDER.get();
            if (CollectionUtils.isEmpty(concurrentHashMap)) {
                return;
            }
            boolean hasSavepoint = ConnectionFactory.hasSavepoint(xid);
            List<SavePointHolder> savePointHolders = savePointMap.get(xid);
            Map<String, ConnectionProxy> connectionProxyMap = concurrentHashMap.get(xid);
            try {
                if (hasSavepoint) {
                    try {
                        if (state.booleanValue()) {
                            Iterator<SavePointHolder> iterator = savePointHolders.iterator();
                            while (iterator.hasNext()) {
                                SavePointHolder savePointHolder = iterator.next();
                                if (!savePointHolder.releaseSavepoint()) continue;
                                iterator.remove();
                            }
                        } else {
                            ArrayList<ConnectionProxy> markedConnectionProxy = new ArrayList<ConnectionProxy>();
                            Iterator<SavePointHolder> iterator = savePointHolders.iterator();
                            while (iterator.hasNext()) {
                                SavePointHolder savePointHolder = iterator.next();
                                ConnectionProxy connectionProxy = savePointHolder.getConnectionProxy();
                                markedConnectionProxy.add(connectionProxy);
                                if (!savePointHolder.rollbackSavePoint()) continue;
                                iterator.remove();
                            }
                            Iterator<Map.Entry<String, ConnectionProxy>> entryIterator = connectionProxyMap.entrySet().iterator();
                            while (entryIterator.hasNext()) {
                                Map.Entry<String, ConnectionProxy> connectionProxyEntry = entryIterator.next();
                                ConnectionProxy value = connectionProxyEntry.getValue();
                                if (markedConnectionProxy.contains(value)) continue;
                                value.rollback();
                                entryIterator.remove();
                            }
                        }
                        break block17;
                    }
                    catch (SQLException e) {
                        exception = e;
                        break block17;
                    }
                }
                for (ConnectionProxy connectionProxy : connectionProxyMap.values()) {
                    try {
                        if (connectionProxy == null) continue;
                        connectionProxy.notify(state);
                    }
                    catch (SQLException e) {
                        exception = e;
                    }
                }
            }
            finally {
                if (!hasSavepoint) {
                    concurrentHashMap.remove(xid);
                    savePointMap.remove(xid);
                }
                if (exception != null) {
                    throw exception;
                }
            }
        }
    }

    public static void createSavepoint(String xid) throws TransactionException {
        try {
            Map<String, List<SavePointHolder>> savePointMap = SAVEPOINT_CONNECTION_HOLDER.get();
            List<SavePointHolder> savePointHolders = savePointMap.get(xid);
            Map<String, Map<String, ConnectionProxy>> concurrentHashMap = CONNECTION_HOLDER.get();
            Map<String, ConnectionProxy> connectionProxyMap = concurrentHashMap.get(xid);
            if (CollectionUtils.isEmpty(savePointHolders)) {
                savePointHolders = new ArrayList<SavePointHolder>();
                for (ConnectionProxy connectionProxy : connectionProxyMap.values()) {
                    SavePointHolder savePointHolder = new SavePointHolder(connectionProxy);
                    savePointHolder.conversionSavePointHolder();
                    savePointHolders.add(savePointHolder);
                }
            } else {
                ArrayList<ConnectionProxy> markedConnectionProxy = new ArrayList<ConnectionProxy>();
                for (SavePointHolder savePointHolder : savePointHolders) {
                    ConnectionProxy connectionProxy = savePointHolder.getConnectionProxy();
                    markedConnectionProxy.add(connectionProxy);
                    savePointHolder.conversionSavePointHolder();
                }
                for (ConnectionProxy connectionProxy : connectionProxyMap.values()) {
                    if (markedConnectionProxy.contains(connectionProxy)) continue;
                    SavePointHolder savePointHolder = new SavePointHolder(connectionProxy);
                    savePointHolder.conversionSavePointHolder();
                    savePointHolders.add(savePointHolder);
                }
            }
            savePointMap.put(xid, savePointHolders);
        }
        catch (SQLException ex) {
            throw new CannotCreateTransactionException("Could not create JDBC savepoint", (Throwable)ex);
        }
    }

    public static boolean hasSavepoint(String xid) {
        Map<String, List<SavePointHolder>> savePointMap = SAVEPOINT_CONNECTION_HOLDER.get();
        List<SavePointHolder> savePointHolders = savePointMap.get(xid);
        return !CollectionUtils.isEmpty(savePointHolders);
    }
}

