/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.spi;

import com.baidu.brpc.client.loadbalance.LoadBalanceFactory;
import com.baidu.brpc.client.loadbalance.LoadBalanceManager;
import com.baidu.brpc.naming.NamingServiceFactory;
import com.baidu.brpc.naming.NamingServiceFactoryManager;
import com.baidu.brpc.protocol.ProtocolFactory;
import com.baidu.brpc.protocol.ProtocolManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.ServiceLoader;

public class ExtensionLoaderManager {
    private static volatile ExtensionLoaderManager instance;
    private Object loadLock = new Object();
    private Boolean isLoaded = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ExtensionLoaderManager getInstance() {
        if (instance != null) return instance;
        Class<ExtensionLoaderManager> clazz = ExtensionLoaderManager.class;
        synchronized (ExtensionLoaderManager.class) {
            if (instance != null) return instance;
            instance = new ExtensionLoaderManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadAllExtensions(String encoding) {
        if (!this.isLoaded.booleanValue()) {
            Object object = this.loadLock;
            synchronized (object) {
                if (!this.isLoaded.booleanValue()) {
                    this.loadNamingService();
                    this.loadProtocol(encoding);
                    this.loadLoadBalance();
                    this.isLoaded = true;
                }
            }
        }
    }

    public void loadNamingService() {
        NamingServiceFactoryManager manager = NamingServiceFactoryManager.getInstance();
        ServiceLoader<NamingServiceFactory> namingServiceFactories = ServiceLoader.load(NamingServiceFactory.class);
        for (NamingServiceFactory namingServiceFactory : namingServiceFactories) {
            manager.registerNamingServiceFactory(namingServiceFactory);
        }
    }

    public void loadProtocol(String encoding) {
        ProtocolManager protocolManager = ProtocolManager.getInstance();
        ServiceLoader<ProtocolFactory> protocolFactories = ServiceLoader.load(ProtocolFactory.class);
        ArrayList<ProtocolFactory> protocolFactoryList = new ArrayList<ProtocolFactory>();
        for (ProtocolFactory protocolFactory : protocolFactories) {
            protocolFactoryList.add(protocolFactory);
        }
        Collections.sort(protocolFactoryList, new Comparator<ProtocolFactory>(){

            @Override
            public int compare(ProtocolFactory o1, ProtocolFactory o2) {
                return o1.getPriority() - o2.getPriority();
            }
        });
        for (ProtocolFactory protocolFactory : protocolFactoryList) {
            protocolManager.registerProtocol(protocolFactory, encoding);
        }
    }

    public void loadLoadBalance() {
        LoadBalanceManager loadBalanceManager = LoadBalanceManager.getInstance();
        ServiceLoader<LoadBalanceFactory> loadBalanceFactories = ServiceLoader.load(LoadBalanceFactory.class);
        for (LoadBalanceFactory loadBalanceFactory : loadBalanceFactories) {
            loadBalanceManager.registerLoadBalanceFactory(loadBalanceFactory);
        }
    }
}

