/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.server;

import com.baidu.brpc.JprotobufRpcMethodInfo;
import com.baidu.brpc.ProtobufRpcMethodInfo;
import com.baidu.brpc.RpcContext;
import com.baidu.brpc.RpcMethodInfo;
import com.baidu.brpc.client.RpcCallback;
import com.baidu.brpc.client.RpcFuture;
import com.baidu.brpc.exceptions.RpcException;
import com.baidu.brpc.interceptor.DefaultInterceptorChain;
import com.baidu.brpc.interceptor.Interceptor;
import com.baidu.brpc.interceptor.ServerPushInterceptor;
import com.baidu.brpc.protocol.Options;
import com.baidu.brpc.protocol.Request;
import com.baidu.brpc.protocol.Response;
import com.baidu.brpc.protocol.nshead.NSHead;
import com.baidu.brpc.protocol.nshead.NSHeadMeta;
import com.baidu.brpc.protocol.push.SPHead;
import com.baidu.brpc.protocol.push.ServerPushProtocol;
import com.baidu.brpc.server.RpcServer;
import com.baidu.brpc.utils.ProtobufUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrpcPushProxy
implements MethodInterceptor {
    private static final Logger log = LoggerFactory.getLogger(BrpcPushProxy.class);
    private static final Set<String> notProxyMethodSet = new HashSet<String>();
    private RpcServer rpcServer;
    private static Map<String, RpcMethodInfo> rpcMethodMap;

    protected BrpcPushProxy(RpcServer rpcServer, Class clazz) {
        Method[] methods;
        this.rpcServer = rpcServer;
        if (!(rpcServer.getProtocol() instanceof ServerPushProtocol)) {
            throw new RpcException(" server protocol should be serverPushProtocl");
        }
        for (Method method : methods = clazz.getDeclaredMethods()) {
            Method syncMethod;
            if (notProxyMethodSet.contains(method.getName())) {
                log.debug("{}:{} does not need to proxy", (Object)method.getDeclaringClass().getName(), (Object)method.getName());
                continue;
            }
            Object[] oriTypes = method.getParameterTypes();
            if (oriTypes.length < 1) {
                throw new IllegalArgumentException("number of arguments cannot be zero");
            }
            if (!String.class.isAssignableFrom(oriTypes[0])) {
                throw new IllegalArgumentException("first arguments must be clientName (String)");
            }
            if (Future.class.isAssignableFrom(method.getReturnType()) && !RpcCallback.class.isAssignableFrom((Class<?>)oriTypes[oriTypes.length - 1])) {
                throw new IllegalArgumentException("returnType is Future, but last argument is not RpcCallback");
            }
            Object[] paramTypesExcludeClientName = (Class[])ArrayUtils.subarray((Object[])oriTypes, (int)1, (int)oriTypes.length);
            int paramLengthExcludeClientName = paramTypesExcludeClientName.length;
            Object[] actualArgTypes = paramTypesExcludeClientName;
            if (paramLengthExcludeClientName >= 1 && RpcCallback.class.isAssignableFrom(paramTypesExcludeClientName[paramLengthExcludeClientName - 1])) {
                actualArgTypes = (Class[])ArrayUtils.subarray((Object[])paramTypesExcludeClientName, (int)0, (int)(paramTypesExcludeClientName.length - 1));
            }
            try {
                syncMethod = method.getDeclaringClass().getMethod(method.getName(), (Class<?>[])actualArgTypes);
            }
            catch (NoSuchMethodException ex) {
                throw new IllegalArgumentException("can not find sync method:" + method.getName());
            }
            ProtobufUtils.MessageType messageType = ProtobufUtils.getMessageType(syncMethod);
            RpcMethodInfo methodInfo = messageType == ProtobufUtils.MessageType.PROTOBUF ? new ProtobufRpcMethodInfo(syncMethod) : (messageType == ProtobufUtils.MessageType.JPROTOBUF ? new JprotobufRpcMethodInfo(syncMethod) : new RpcMethodInfo(syncMethod));
            rpcMethodMap.put(method.getName(), methodInfo);
            log.debug("client serviceName={}, methodName={}", (Object)method.getDeclaringClass().getName(), (Object)method.getName());
        }
    }

    public static <T> T getProxy(RpcServer rpcServer, Class clazz) {
        Enhancer en = new Enhancer();
        en.setSuperclass(clazz);
        en.setCallback((Callback)new BrpcPushProxy(rpcServer, clazz));
        return (T)en.create();
    }

    public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        Validate.notNull((Object)this.rpcServer);
        String methodName = method.getName();
        RpcMethodInfo rpcMethodInfo = rpcMethodMap.get(methodName);
        if (rpcMethodInfo == null) {
            log.debug("{}:{} does not need to proxy", (Object)method.getDeclaringClass().getName(), (Object)methodName);
            return proxy.invokeSuper(obj, args);
        }
        int argLength = args.length;
        List<Object> argList = Arrays.asList(args);
        argList = argList.subList(1, argLength);
        argLength = argList.size();
        Object[] actualArgs = argList.toArray();
        Request request = null;
        Response response = null;
        ArrayList<Interceptor> interceptors = null;
        int readTimeout = 10000;
        int writeTimeout = 10000;
        request = this.rpcServer.getProtocol().createRequest();
        response = this.rpcServer.getProtocol().getResponse();
        request.setClientName((String)args[0]);
        SPHead spHead = ((ServerPushProtocol)this.rpcServer.getProtocol()).createSPHead();
        spHead.setType(2);
        request.setSpHead(spHead);
        request.setCompressType(Options.CompressType.COMPRESS_TYPE_NONE.getNumber());
        interceptors = new ArrayList<Interceptor>();
        ServerPushInterceptor serverPushInterceptor = new ServerPushInterceptor();
        serverPushInterceptor.setRpcServer(this.rpcServer);
        interceptors.add(serverPushInterceptor);
        try {
            request.setTarget(obj);
            request.setRpcMethodInfo(rpcMethodInfo);
            request.setTargetMethod(rpcMethodInfo.getMethod());
            request.setServiceName(rpcMethodInfo.getServiceName());
            request.setMethodName(rpcMethodInfo.getMethodName());
            NSHeadMeta nsHeadMeta = rpcMethodInfo.getNsHeadMeta();
            NSHead nsHead = nsHeadMeta == null ? new NSHead() : new NSHead(0, nsHeadMeta.id(), nsHeadMeta.version(), nsHeadMeta.provider(), 0);
            request.setNsHead(nsHead);
            RpcCallback callback = null;
            if (argLength > 1) {
                int startIndex = 0;
                int endIndex = argLength - 1;
                if (actualArgs[endIndex] instanceof RpcCallback) {
                    callback = (RpcCallback)actualArgs[endIndex];
                    --endIndex;
                    --argLength;
                }
                if (argLength <= 0) {
                    throw new RpcException(0, "invalid params");
                }
                Object[] sendArgs = new Object[argLength];
                int i = 0;
                while (startIndex <= endIndex) {
                    sendArgs[i] = actualArgs[startIndex++];
                    ++i;
                }
                request.setArgs(sendArgs);
                request.setCallback(callback);
            } else {
                request.setArgs(actualArgs);
            }
            if (RpcContext.isSet()) {
                RpcContext rpcContext = RpcContext.getContext();
                if (rpcContext.getRequestKvAttachment() != null) {
                    request.setKvAttachment(rpcContext.getRequestKvAttachment());
                }
                if (rpcContext.getRequestBinaryAttachment() != null) {
                    request.setBinaryAttachment(rpcContext.getRequestBinaryAttachment());
                }
                if (rpcContext.getLogId() != null) {
                    request.getNsHead().logId = rpcContext.getLogId();
                }
                if (rpcContext.getServiceTag() != null) {
                    request.setServiceTag(rpcContext.getServiceTag());
                }
                if (rpcContext.getReadTimeoutMillis() != null) {
                    request.setReadTimeoutMillis(rpcContext.getReadTimeoutMillis());
                }
                if (rpcContext.getWriteTimeoutMillis() != null) {
                    request.setWriteTimeoutMillis(rpcContext.getWriteTimeoutMillis());
                }
                rpcContext.reset();
            }
            if (request.getReadTimeoutMillis() == null) {
                request.setReadTimeoutMillis(readTimeout);
            }
            if (request.getWriteTimeoutMillis() == null) {
                request.setWriteTimeoutMillis(writeTimeout);
            }
            DefaultInterceptorChain interceptorChain = new DefaultInterceptorChain(interceptors);
            try {
                interceptorChain.intercept(request, response);
                if (response.getException() != null) {
                    throw new RpcException(response.getException());
                }
                if (request.getCallback() != null) {
                    RpcFuture endIndex = response.getRpcFuture();
                    return endIndex;
                }
                Object endIndex = response.getResult();
                return endIndex;
            }
            catch (Exception ex) {
                log.error("exception :", (Throwable)ex);
                throw new RpcException(response.getException());
            }
        }
        finally {
            if (request != null) {
                request.release();
            }
        }
    }

    public Map<String, RpcMethodInfo> getRpcMethodMap() {
        return rpcMethodMap;
    }

    static {
        notProxyMethodSet.add("getClass");
        notProxyMethodSet.add("hashCode");
        notProxyMethodSet.add("equals");
        notProxyMethodSet.add("clone");
        notProxyMethodSet.add("toString");
        notProxyMethodSet.add("notify");
        notProxyMethodSet.add("notifyAll");
        notProxyMethodSet.add("wait");
        notProxyMethodSet.add("finalize");
        rpcMethodMap = new HashMap<String, RpcMethodInfo>();
    }
}

