/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.protocol.http;

import com.baidu.brpc.exceptions.RpcException;
import com.baidu.brpc.protocol.http.BrpcHttpObjectEncoder;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.util.AsciiString;
import io.netty.util.CharsetUtil;
import java.util.LinkedList;

public class BrpcHttpRequestEncoder
extends BrpcHttpObjectEncoder<HttpRequest> {
    private static final char SLASH = '/';
    private static final char QUESTION_MARK = '?';
    private static final int SLASH_AND_SPACE_SHORT = 12064;
    private static final int SPACE_SLASH_AND_SPACE_MEDIUM = 0x202F20;

    @Override
    public boolean acceptOutboundMessage(Object msg) throws Exception {
        return super.acceptOutboundMessage(msg) && !(msg instanceof HttpResponse);
    }

    @Override
    protected void encodeInitialLine(ByteBuf buf, HttpRequest request) throws Exception {
        ByteBufUtil.copy((AsciiString)request.method().asciiName(), (ByteBuf)buf);
        String uri = request.uri();
        if (uri.isEmpty()) {
            ByteBufUtil.writeMediumBE((ByteBuf)buf, (int)0x202F20);
        } else {
            CharSequence uriCharSequence = uri;
            boolean needSlash = false;
            int start = uri.indexOf("://");
            if (start != -1 && uri.charAt(0) != '/') {
                int index = uri.indexOf(63, start += 3);
                if (index == -1) {
                    if (uri.lastIndexOf(47) < start) {
                        needSlash = true;
                    }
                } else if (uri.lastIndexOf(47, index) < start) {
                    uriCharSequence = new StringBuilder(uri).insert(index, '/');
                }
            }
            buf.writeByte(32).writeCharSequence(uriCharSequence, CharsetUtil.UTF_8);
            if (needSlash) {
                ByteBufUtil.writeShortBE((ByteBuf)buf, (int)12064);
            } else {
                buf.writeByte(32);
            }
        }
        buf.writeCharSequence((CharSequence)request.protocolVersion().text(), CharsetUtil.US_ASCII);
        ByteBufUtil.writeShortBE((ByteBuf)buf, (int)3338);
    }

    public ByteBuf encode(Object msg) throws Exception {
        LinkedList<Object> list = new LinkedList<Object>();
        super.encode(msg, list);
        if (list.size() == 1) {
            return (ByteBuf)list.get(0);
        }
        throw new RpcException(5, "encode request failed");
    }
}

