/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.naming;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrpcURL {
    private static final Logger log = LoggerFactory.getLogger(BrpcURL.class);
    private String schema;
    private String hostPorts;
    private String path;
    private Map<String, Object> queryMap = new HashMap<String, Object>();

    public BrpcURL(String uri) {
        int index = uri.indexOf("://");
        if (index < 0) {
            throw new IllegalArgumentException("invalid uri:" + uri);
        }
        this.schema = uri.substring(0, index).toLowerCase();
        int index2 = uri.indexOf(47, index + 3);
        int index3 = uri.indexOf(63, index + 3);
        this.hostPorts = index2 > 0 ? uri.substring(index + 3, index2) : (index3 > 0 ? uri.substring(index + 3, index3) : uri.substring(index + 3));
        this.path = index2 > 0 ? (index3 > 0 ? uri.substring(index2, index3) : uri.substring(index2)) : "/";
        if (index3 > 0) {
            String[] querySplits;
            String query = uri.substring(index3 + 1);
            for (String kv : querySplits = query.split("&")) {
                String[] kvSplit = kv.split("=");
                this.queryMap.put(kvSplit[0], kvSplit[1]);
            }
        }
    }

    public void addParameter(String key, Object value) {
        this.queryMap.put(key, value);
    }

    public Object getParameter(String key) {
        return this.queryMap.get(key);
    }

    public Object getParameter(String key, Object defaultValue) {
        Object value = this.queryMap.get(key);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public int getIntParameter(String key, int defaultValue) {
        Object value = this.queryMap.get(key);
        if (value != null) {
            return Integer.valueOf((String)value);
        }
        return defaultValue;
    }

    public String getStringParameter(String key, String defaultValue) {
        Object value = this.queryMap.get(key);
        if (value != null) {
            return (String)value;
        }
        return defaultValue;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.schema).append("://");
        if (StringUtils.isNotBlank((CharSequence)this.hostPorts)) {
            sb.append(this.hostPorts);
        }
        sb.append(this.path);
        if (this.queryMap.size() > 0) {
            sb.append("?");
            for (Map.Entry<String, Object> entry : this.queryMap.entrySet()) {
                sb.append(entry.getKey()).append("=").append(entry.getValue());
            }
        }
        return sb.toString();
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void setHostPorts(String hostPorts) {
        this.hostPorts = hostPorts;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setQueryMap(Map<String, Object> queryMap) {
        this.queryMap = queryMap;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getHostPorts() {
        return this.hostPorts;
    }

    public String getPath() {
        return this.path;
    }

    public Map<String, Object> getQueryMap() {
        return this.queryMap;
    }
}

