/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.interceptor;

import com.baidu.brpc.client.AsyncAwareFuture;
import com.baidu.brpc.client.RpcFuture;
import com.baidu.brpc.exceptions.RpcException;
import com.baidu.brpc.interceptor.AbstractInterceptor;
import com.baidu.brpc.interceptor.InterceptorChain;
import com.baidu.brpc.protocol.Request;
import com.baidu.brpc.protocol.Response;
import com.baidu.brpc.server.ChannelManager;
import com.baidu.brpc.server.RpcServer;
import io.netty.channel.Channel;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerPushInterceptor
extends AbstractInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(ServerPushInterceptor.class);
    protected RpcServer rpcServer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void aroundProcess(Request request, Response response, InterceptorChain chain) throws Exception {
        RpcException exception = null;
        int currentTryTimes = 0;
        int maxTryTimes = this.rpcServer.getRpcServerOptions().getMaxTryTimes();
        while (currentTryTimes < maxTryTimes) {
            try {
                this.invokeRpc(request, response);
                break;
            }
            catch (RpcException ex) {
                exception = ex;
                if (exception.getCode() != 6) continue;
                break;
            }
            finally {
                ++currentTryTimes;
            }
        }
        if (response.getResult() == null && response.getRpcFuture() == null) {
            if (exception == null) {
                exception = new RpcException(0, "unknown error");
            }
            response.setException(exception);
        }
    }

    protected void invokeRpc(Request request, Response response) throws Exception {
        this.selectChannel(request);
        this.rpcCore(request, response);
    }

    protected Channel selectChannel(Request request) {
        String clientName;
        ChannelManager channelManager = ChannelManager.getInstance();
        Channel channel = channelManager.getChannel(clientName = request.getClientName());
        if (channel == null) {
            LOG.error("cannot find a valid channel by name:" + clientName);
            throw new RpcException("cannot find a valid channel by name:" + clientName);
        }
        request.setChannel(channel);
        return channel;
    }

    protected void rpcCore(Request request, Response response) throws Exception {
        AsyncAwareFuture future = this.rpcServer.sendServerPush(request);
        if (future.isAsync()) {
            response.setRpcFuture((RpcFuture)future);
        } else {
            response.setResult(future.get(request.getReadTimeoutMillis().intValue(), TimeUnit.MILLISECONDS));
        }
    }

    public RpcServer getRpcServer() {
        return this.rpcServer;
    }

    public void setRpcServer(RpcServer rpcServer) {
        this.rpcServer = rpcServer;
    }
}

