/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.compress;

import com.baidu.brpc.ProtobufRpcMethodInfo;
import com.baidu.brpc.RpcMethodInfo;
import com.baidu.brpc.buffer.DynamicCompositeByteBuf;
import com.baidu.brpc.buffer.DynamicCompositeByteBufInputStream;
import com.baidu.brpc.compress.Compress;
import com.baidu.brpc.utils.IOUtils;
import com.google.protobuf.CodedOutputStream;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZlibCompress
implements Compress {
    private static final Logger log = LoggerFactory.getLogger(ZlibCompress.class);

    @Override
    public ByteBuf compressInput(Object proto, RpcMethodInfo rpcMethodInfo) throws IOException {
        int protoSize = rpcMethodInfo.getInputSerializedSize(proto);
        ByteBuf resBuf = Unpooled.buffer((int)protoSize);
        Object outputStream = new ByteBufOutputStream(resBuf);
        outputStream = new DeflaterOutputStream((OutputStream)outputStream);
        CodedOutputStream codedOutputStream = CodedOutputStream.newInstance((OutputStream)outputStream, (int)protoSize);
        rpcMethodInfo.inputWriteToStream(proto, codedOutputStream);
        ((OutputStream)outputStream).close();
        return resBuf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object uncompressOutput(ByteBuf byteBuf, RpcMethodInfo rpcMethodInfo) throws IOException {
        Object inputStream = new ByteBufInputStream(byteBuf);
        inputStream = new InflaterInputStream((InputStream)inputStream);
        try {
            if (rpcMethodInfo instanceof ProtobufRpcMethodInfo) {
                Object object = ((ProtobufRpcMethodInfo)rpcMethodInfo).outputDecode((InputStream)inputStream);
                return object;
            }
            byte[] uncompressedBytes = IOUtils.readInputStream((InputStream)inputStream);
            Object object = rpcMethodInfo.outputDecode(uncompressedBytes);
            return object;
        }
        finally {
            ((InputStream)inputStream).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object uncompressOutput(byte[] bytes, RpcMethodInfo rpcMethodInfo) throws IOException {
        InputStream inputStream = new ByteArrayInputStream(bytes);
        inputStream = new InflaterInputStream(inputStream);
        try {
            if (rpcMethodInfo instanceof ProtobufRpcMethodInfo) {
                Object object = ((ProtobufRpcMethodInfo)rpcMethodInfo).outputDecode(inputStream);
                return object;
            }
            byte[] uncompressedBytes = IOUtils.readInputStream(inputStream);
            Object object = rpcMethodInfo.outputDecode(uncompressedBytes);
            return object;
        }
        finally {
            inputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object uncompressOutput(DynamicCompositeByteBuf byteBuf, RpcMethodInfo rpcMethodInfo) throws IOException {
        InputStream inputStream = new DynamicCompositeByteBufInputStream(byteBuf);
        inputStream = new InflaterInputStream(inputStream);
        try {
            if (rpcMethodInfo instanceof ProtobufRpcMethodInfo) {
                Object object = ((ProtobufRpcMethodInfo)rpcMethodInfo).outputDecode(inputStream);
                return object;
            }
            byte[] uncompressedBytes = IOUtils.readInputStream(inputStream);
            Object object = rpcMethodInfo.outputDecode(uncompressedBytes);
            return object;
        }
        finally {
            inputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object uncompressInput(ByteBuf byteBuf, RpcMethodInfo rpcMethodInfo) throws IOException {
        Object inputStream = new ByteBufInputStream(byteBuf);
        inputStream = new InflaterInputStream((InputStream)inputStream);
        try {
            if (rpcMethodInfo instanceof ProtobufRpcMethodInfo) {
                Object object = ((ProtobufRpcMethodInfo)rpcMethodInfo).inputDecode((InputStream)inputStream);
                return object;
            }
            byte[] uncompressedBytes = IOUtils.readInputStream((InputStream)inputStream);
            Object object = rpcMethodInfo.inputDecode(uncompressedBytes);
            return object;
        }
        finally {
            ((InputStream)inputStream).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object uncompressInput(byte[] bytes, RpcMethodInfo rpcMethodInfo) throws IOException {
        InputStream inputStream = new ByteArrayInputStream(bytes);
        inputStream = new InflaterInputStream(inputStream);
        try {
            if (rpcMethodInfo instanceof ProtobufRpcMethodInfo) {
                Object object = ((ProtobufRpcMethodInfo)rpcMethodInfo).inputDecode(inputStream);
                return object;
            }
            byte[] uncompressedBytes = IOUtils.readInputStream(inputStream);
            Object object = rpcMethodInfo.inputDecode(uncompressedBytes);
            return object;
        }
        finally {
            inputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object uncompressInput(DynamicCompositeByteBuf byteBuf, RpcMethodInfo rpcMethodInfo) throws IOException {
        InputStream inputStream = new DynamicCompositeByteBufInputStream(byteBuf);
        inputStream = new InflaterInputStream(inputStream);
        try {
            if (rpcMethodInfo instanceof ProtobufRpcMethodInfo) {
                Object object = ((ProtobufRpcMethodInfo)rpcMethodInfo).inputDecode(inputStream);
                return object;
            }
            byte[] uncompressedBytes = IOUtils.readInputStream(inputStream);
            Object object = rpcMethodInfo.inputDecode(uncompressedBytes);
            return object;
        }
        finally {
            inputStream.close();
        }
    }

    @Override
    public ByteBuf compressOutput(Object proto, RpcMethodInfo rpcMethodInfo) throws IOException {
        int protoSize = rpcMethodInfo.getOutputSerializedSize(proto);
        ByteBuf resBuf = Unpooled.buffer((int)protoSize);
        Object outputStream = new ByteBufOutputStream(resBuf);
        outputStream = new DeflaterOutputStream((OutputStream)outputStream);
        CodedOutputStream codedOutputStream = CodedOutputStream.newInstance((OutputStream)outputStream, (int)protoSize);
        rpcMethodInfo.outputWriteToStream(proto, codedOutputStream);
        ((OutputStream)outputStream).close();
        return resBuf;
    }
}

