/*
 * Copyright (c) 2018 Baidu, Inc. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.baidu.brpc.server;

/**
 * Http constant class.
 *
 * @author xiemalin
 * @since 3.1.0
 */
public class HttpConstants {

    /** The Constant LINE_BREAK. */
    public static final String LINE_BREAK = "<br>";
    
    /** The Constant PRE_STARTS. */
    public static final String PRE_STARTS = "<pre>";
    
    /** The Constant PRE_ENDS. */
    public static final String PRE_ENDS = "</pre>";
    
    /** The Constant HTML_HEAD. */
    public static final String HTML_HEAD = "<html><head><meta http-equiv=\"Content-Type\" "
            + "content=\"text/html; charset=utf-8\"></head>";
    
    /** The Constant HTML_TAIL. */
    public static final String HTML_TAIL = "</html>";
    
    /** The Constant BOLD_FONT. */
    public static final String BOLD_FONT = "<B>";
    
    /** The Constant BOLD_FONT_END. */
    public static final String BOLD_FONT_END = "</B>";
}
