/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.tracer.plugins.springcloud.instruments.feign;

import com.alipay.sofa.tracer.plugins.springcloud.instruments.feign.SofaTracerFeignClient;
import com.alipay.sofa.tracer.plugins.springcloud.instruments.feign.SofaTracerLoadBalancedFeignClient;
import feign.Client;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.netflix.ribbon.SpringClientFactory;
import org.springframework.cloud.openfeign.FeignContext;
import org.springframework.cloud.openfeign.ribbon.CachingSpringLoadBalancerFactory;
import org.springframework.cloud.openfeign.ribbon.LoadBalancerFeignClient;

public class SofaTracerFeignContext
extends FeignContext {
    private FeignContext delegateContext;
    private BeanFactory beanFactory;

    public SofaTracerFeignContext(FeignContext delegateContext, BeanFactory beanFactory) {
        this.delegateContext = delegateContext;
        this.beanFactory = beanFactory;
    }

    public <T> T getInstance(String name, Class<T> type) {
        Object object = this.delegateContext.getInstance(name, type);
        return (T)this.wrapperFeignClient(object);
    }

    public <T> Map<String, T> getInstances(String name, Class<T> type) {
        Map instances = this.delegateContext.getInstances(name, type);
        HashMap tracerInstances = new HashMap();
        if (instances != null) {
            instances.entrySet().forEach(item -> tracerInstances.put(item.getKey(), this.wrapperFeignClient(item.getValue())));
        }
        return tracerInstances;
    }

    private Object wrapperFeignClient(Object bean) {
        if (bean instanceof SofaTracerFeignClient || bean instanceof SofaTracerLoadBalancedFeignClient) {
            return bean;
        }
        if (bean instanceof Client) {
            if (bean instanceof LoadBalancerFeignClient && !(bean instanceof SofaTracerLoadBalancedFeignClient)) {
                return new SofaTracerLoadBalancedFeignClient(this.newSofaTracerFeignClient(((LoadBalancerFeignClient)bean).getDelegate()), (CachingSpringLoadBalancerFactory)this.beanFactory.getBean(CachingSpringLoadBalancerFactory.class), (SpringClientFactory)this.beanFactory.getBean(SpringClientFactory.class));
            }
            return this.newSofaTracerFeignClient((Client)bean);
        }
        return bean;
    }

    private SofaTracerFeignClient newSofaTracerFeignClient(Client delegate) {
        return new SofaTracerFeignClient(delegate);
    }
}

