/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.common.util;

import java.util.Properties;

public class EnvironmentUtils {
    private static Properties properties = new Properties();

    public static String getProperty(String key) {
        String value = properties.getProperty(key);
        if (value == null) {
            return System.getProperty(key);
        }
        return value;
    }

    public static String getProperty(String key, String defaultValue) {
        String value = properties.getProperty(key);
        if (value == null) {
            return System.getProperty(key, defaultValue);
        }
        return value;
    }

    public static void setProperty(String key, String value) {
        properties.setProperty(key, value);
    }

    public static void setSystemProperty(String key, String value) {
        System.setProperty(key, value);
    }

    public static void clearProperty(String key) {
        properties.remove(key);
    }

    public static void clearSystemProperty(String key) {
        System.clearProperty(key);
    }

    public static boolean isOpenSecurity() {
        return EnvironmentUtils.getProperty("sofa.ark.telnet.security.enable", "false").equalsIgnoreCase("true");
    }
}

