/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.common.util;

import com.alipay.sofa.ark.exception.ArkRuntimeException;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;

public class ClassLoaderUtils {
    private static final String JAVA_AGENT_MARK = "-javaagent:";
    private static final String JAVA_AGENT_OPTION_MARK = "=";

    public static ClassLoader pushContextClassLoader(ClassLoader newClassLoader) {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(newClassLoader);
        return oldClassLoader;
    }

    public static void popContextClassLoader(ClassLoader oldClassLoader) {
        Thread.currentThread().setContextClassLoader(oldClassLoader);
    }

    public static URL[] getAgentClassPath() {
        List<String> inputArguments = AccessController.doPrivileged(new PrivilegedAction<List<String>>(){

            @Override
            public List<String> run() {
                return ManagementFactory.getRuntimeMXBean().getInputArguments();
            }
        });
        ArrayList<URL> agentPaths = new ArrayList<URL>();
        for (String argument : inputArguments) {
            if (!argument.startsWith(JAVA_AGENT_MARK)) continue;
            argument = argument.substring(JAVA_AGENT_MARK.length());
            try {
                String path = argument.split(JAVA_AGENT_OPTION_MARK)[0];
                URL url = new File(path).toURI().toURL();
                agentPaths.add(url);
            }
            catch (Throwable e) {
                throw new ArkRuntimeException("Failed to create java agent classloader", e);
            }
        }
        return agentPaths.toArray(new URL[0]);
    }
}

