/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.jraft.bootstrap;

import com.alipay.remoting.rpc.RpcClient;
import com.alipay.remoting.rpc.RpcServer;
import com.alipay.remoting.rpc.protocol.UserProcessor;
import com.alipay.sofa.jraft.Node;
import com.alipay.sofa.jraft.RaftGroupService;
import com.alipay.sofa.jraft.StateMachine;
import com.alipay.sofa.jraft.conf.Configuration;
import com.alipay.sofa.jraft.core.NodeImpl;
import com.alipay.sofa.jraft.entity.PeerId;
import com.alipay.sofa.jraft.option.NodeOptions;
import com.alipay.sofa.jraft.rpc.RaftRpcServerFactory;
import com.alipay.sofa.jraft.rpc.impl.AbstractBoltClientService;
import com.alipay.sofa.registry.common.model.store.URL;
import com.alipay.sofa.registry.jraft.bootstrap.RaftServerConfig;
import com.alipay.sofa.registry.jraft.bootstrap.ServiceStateMachine;
import com.alipay.sofa.registry.jraft.command.NotifyLeaderChange;
import com.alipay.sofa.registry.jraft.handler.NotifyLeaderChangeHandler;
import com.alipay.sofa.registry.jraft.handler.RaftServerConnectionHandler;
import com.alipay.sofa.registry.jraft.handler.RaftServerHandler;
import com.alipay.sofa.registry.jraft.processor.FollowerProcessListener;
import com.alipay.sofa.registry.jraft.processor.LeaderProcessListener;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.metrics.ReporterUtils;
import com.alipay.sofa.registry.net.NetUtil;
import com.alipay.sofa.registry.remoting.ChannelHandler;
import com.alipay.sofa.registry.remoting.bolt.BoltServer;
import com.alipay.sofa.registry.remoting.bolt.SyncUserProcessorAdapter;
import com.alipay.sofa.registry.util.FileUtils;
import com.codahale.metrics.MetricRegistry;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RaftServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(RaftServer.class);
    private RaftGroupService raftGroupService;
    private Node node;
    private ServiceStateMachine fsm;
    private PeerId serverId;
    private Configuration initConf;
    private String groupId;
    private String dataPath;
    private List<ChannelHandler> serverHandlers = new ArrayList<ChannelHandler>();
    private LeaderProcessListener leaderProcessListener;
    private FollowerProcessListener followerProcessListener;
    private BoltServer boltServer;

    public RaftServer(String dataPath, String groupId, String serverIdStr, String initConfStr) {
        this.dataPath = dataPath;
        this.groupId = groupId;
        this.serverId = new PeerId();
        if (!this.serverId.parse(serverIdStr)) {
            throw new IllegalArgumentException("Fail to parse serverId:" + serverIdStr);
        }
        this.initConf = new Configuration();
        if (!this.initConf.parse(initConfStr)) {
            throw new IllegalArgumentException("Fail to parse initConf:" + initConfStr);
        }
    }

    public void start(RaftServerConfig raftServerConfig) throws IOException {
        FileUtils.forceMkdir((File)new File(this.dataPath));
        this.serverHandlers.add(new RaftServerHandler(this));
        this.serverHandlers.add(new RaftServerConnectionHandler());
        this.boltServer = new BoltServer(new URL(NetUtil.getLocalAddress().getHostAddress(), this.serverId.getPort()), this.serverHandlers);
        this.boltServer.initServer();
        RpcServer rpcServer = this.boltServer.getRpcServer();
        RaftRpcServerFactory.addRaftRequestProcessors((RpcServer)rpcServer);
        this.fsm = ServiceStateMachine.getInstance();
        this.fsm.setLeaderProcessListener(this.leaderProcessListener);
        this.fsm.setFollowerProcessListener(this.followerProcessListener);
        NodeOptions nodeOptions = this.initNodeOptions(raftServerConfig);
        this.raftGroupService = new RaftGroupService(this.groupId, this.serverId, nodeOptions, rpcServer);
        this.node = this.raftGroupService.start();
        if (raftServerConfig.isEnableMetrics()) {
            ReporterUtils.startSlf4jReporter((long)raftServerConfig.getEnableMetricsReporterPeriod(), (MetricRegistry)this.node.getNodeMetrics().getMetricRegistry(), (Logger)raftServerConfig.getMetricsLogger());
        }
        RpcClient raftClient = ((AbstractBoltClientService)((NodeImpl)this.node).getRpcService()).getRpcClient();
        NotifyLeaderChangeHandler notifyLeaderChangeHandler = new NotifyLeaderChangeHandler(this.groupId, null);
        raftClient.registerUserProcessor((UserProcessor)new SyncUserProcessorAdapter((ChannelHandler)notifyLeaderChangeHandler));
    }

    public void shutdown() {
        if (this.raftGroupService != null) {
            this.raftGroupService.shutdown();
        }
    }

    private NodeOptions initNodeOptions(RaftServerConfig raftServerConfig) {
        NodeOptions nodeOptions = new NodeOptions();
        nodeOptions.setElectionTimeoutMs(raftServerConfig.getElectionTimeoutMs());
        nodeOptions.setDisableCli(false);
        nodeOptions.setSnapshotIntervalSecs(raftServerConfig.getSnapshotIntervalSecs());
        nodeOptions.setInitialConf(this.initConf);
        nodeOptions.setFsm((StateMachine)this.fsm);
        nodeOptions.setLogUri(this.dataPath + File.separator + "log");
        nodeOptions.setRaftMetaUri(this.dataPath + File.separator + "raft_meta");
        nodeOptions.setSnapshotUri(this.dataPath + File.separator + "snapshot");
        if (raftServerConfig.isEnableMetrics()) {
            nodeOptions.setEnableMetrics(raftServerConfig.isEnableMetrics());
        }
        return nodeOptions;
    }

    public String redirect() {
        PeerId leader;
        if (this.node != null && (leader = this.node.getLeaderId()) != null) {
            return leader.toString();
        }
        return null;
    }

    public void sendNotify(PeerId leader, String sender) {
        if (this.boltServer == null) {
            LOGGER.error("Send notify leader change error!server must be started!");
            throw new IllegalStateException("Send notify leader change error!server must be started!");
        }
        NotifyLeaderChange notifyLeaderChange = new NotifyLeaderChange(leader);
        notifyLeaderChange.setSender(sender);
        Collection channels = this.boltServer.getChannels();
        ArrayList throwables = new ArrayList();
        channels.forEach(channel -> {
            try {
                this.boltServer.sendSync(channel, (Object)notifyLeaderChange, 1000);
            }
            catch (Exception e) {
                LOGGER.error("Send notify leader change error!url:{}", (Object)channel.getRemoteAddress(), (Object)e);
                throwables.add(e);
            }
        });
        if (!throwables.isEmpty()) {
            LOGGER.error("Send notify leader change error!");
            throw new RuntimeException("Send notify leader change error!");
        }
    }

    public ServiceStateMachine getFsm() {
        return this.fsm;
    }

    public Node getNode() {
        return this.node;
    }

    public void setLeaderProcessListener(LeaderProcessListener leaderProcessListener) {
        this.leaderProcessListener = leaderProcessListener;
    }

    public void setFollowerProcessListener(FollowerProcessListener followerProcessListener) {
        this.followerProcessListener = followerProcessListener;
    }
}

