/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.meta.resource;

import com.alipay.sofa.jraft.entity.PeerId;
import com.alipay.sofa.registry.common.model.Node;
import com.alipay.sofa.registry.common.model.metaserver.MetaNode;
import com.alipay.sofa.registry.common.model.store.URL;
import com.alipay.sofa.registry.core.model.Result;
import com.alipay.sofa.registry.net.NetUtil;
import com.alipay.sofa.registry.server.meta.bootstrap.NodeConfig;
import com.alipay.sofa.registry.server.meta.registry.Registry;
import com.alipay.sofa.registry.server.meta.remoting.RaftExchanger;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Path(value="manage")
public class MetaStoreResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetaStoreResource.class);
    @Autowired
    private Registry metaServerRegistry;
    @Autowired
    private NodeConfig nodeConfig;
    @Autowired
    private RaftExchanger raftExchanger;

    @POST
    @Path(value="changePeer")
    @Produces(value={"application/json"})
    public Result changePeer(@FormParam(value="ipAddressList") String ipAddressList) {
        Object[] ipAddressArr;
        Result result = new Result();
        result.setSuccess(false);
        List<String> ipAddressList0 = null;
        if (StringUtils.isNotBlank((String)ipAddressList) && (ipAddressArr = StringUtils.split((String)StringUtils.trim((String)ipAddressList), (char)',')) != null) {
            ipAddressList0 = Lists.newArrayList((Object[])ipAddressArr);
        }
        if (ipAddressList0 == null || ipAddressList0.size() <= 0) {
            String msg = String.format("Empty ipAddressList from input: %s", ipAddressList);
            LOGGER.error(msg);
            result.setMessage(msg);
            return result;
        }
        ipAddressList0 = ipAddressList0.stream().map(NetUtil::getIPAddressFromDomain).collect(Collectors.toList());
        try {
            this.raftExchanger.changePeer(ipAddressList0);
            Thread.sleep(3000L);
            ArrayList metaNodes = Lists.newArrayList();
            for (String ipAddress : ipAddressList0) {
                MetaNode metaNode = new MetaNode(new URL(ipAddress, 0), this.nodeConfig.getLocalDataCenter());
                metaNodes.add(metaNode);
            }
            this.metaServerRegistry.setNodes(metaNodes);
            result.setSuccess(true);
            LOGGER.info("Change peer ipAddressList {} to store!", ipAddressList0);
        }
        catch (Exception e) {
            String msg = String.format("Error when changePeer\uff1a %s", e.getMessage());
            result.setMessage(msg);
            LOGGER.error(msg, (Throwable)e);
        }
        return result;
    }

    @POST
    @Path(value="resetPeer")
    @Produces(value={"application/json"})
    public Result resetPeer(@FormParam(value="ipAddressList") String ipAddressList) {
        Object[] ipAddressArr;
        Result result = new Result();
        result.setSuccess(false);
        List<String> ipAddressList0 = null;
        if (StringUtils.isNotBlank((String)ipAddressList) && (ipAddressArr = StringUtils.split((String)StringUtils.trim((String)ipAddressList), (char)',')) != null) {
            ipAddressList0 = Lists.newArrayList((Object[])ipAddressArr);
        }
        if (ipAddressList0 == null || ipAddressList0.size() <= 0) {
            String msg = String.format("Empty ipAddressList from input: %s", ipAddressList);
            LOGGER.error(msg);
            result.setMessage(msg);
            return result;
        }
        ipAddressList0 = ipAddressList0.stream().map(NetUtil::getIPAddressFromDomain).collect(Collectors.toList());
        try {
            this.raftExchanger.resetPeer(ipAddressList0);
            ArrayList metaNodes = Lists.newArrayList();
            for (String ipAddress : ipAddressList0) {
                MetaNode metaNode = new MetaNode(new URL(ipAddress, 0), this.nodeConfig.getLocalDataCenter());
                metaNodes.add(metaNode);
            }
            this.metaServerRegistry.setNodes(metaNodes);
            result.setSuccess(true);
            LOGGER.info("Reset peer ipAddressList {} to store!", ipAddressList0);
        }
        catch (Exception e) {
            String msg = String.format("Error when resetPeer\uff1a %s", e.getMessage());
            result.setMessage(msg);
            LOGGER.error(msg, (Throwable)e);
        }
        return result;
    }

    @POST
    @Path(value="removePeer")
    @Produces(value={"application/json"})
    public Result remove(Map<String, String> map) {
        Result result = new Result();
        if (map != null && !map.isEmpty()) {
            HashMap throwables = new HashMap();
            map.forEach((ipAddress, dataCenter) -> {
                try {
                    if (!this.nodeConfig.getLocalDataCenter().equals(dataCenter)) {
                        LOGGER.error("Error input dataCenter {} ,current dataCenter {}!", dataCenter, (Object)this.nodeConfig.getLocalDataCenter());
                        throwables.put(ipAddress, "Error input dataCenter");
                        return;
                    }
                    ipAddress = NetUtil.getIPAddressFromDomain((String)ipAddress);
                    this.raftExchanger.removePeer((String)ipAddress);
                    this.metaServerRegistry.cancel((String)ipAddress, Node.NodeType.META);
                    LOGGER.info("Remove peer ipAddress {} to store!", ipAddress);
                }
                catch (Exception e) {
                    LOGGER.error("Error remove peer ipAddress {} to store!", ipAddress, (Object)e);
                    throwables.put(ipAddress, e.getMessage());
                }
            });
            if (throwables.isEmpty()) {
                result.setSuccess(true);
            } else {
                result.setSuccess(false);
                result.setMessage(String.format("Nod remove all peer node,there are %s exception!", throwables.size()));
            }
        } else {
            result.setSuccess(false);
            result.setMessage("Input node map is empty!");
        }
        return result;
    }

    @GET
    @Path(value="queryPeer")
    @Produces(value={"application/json"})
    public List<String> getMetaList() {
        List<PeerId> peerIds = this.raftExchanger.getPeers();
        return peerIds.stream().map(PeerId::getIp).collect(Collectors.toList());
    }
}

